/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.data.baumbach.AngriffListe;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.baumbach.AngriffPruefer;
import java.util.List;

public class AngriffListePruefer
implements Pruefend<List<Angriff>> {
    @Override
    public boolean pruefeEingabe(List<Angriff> angriffe) throws IllegalArgumentException, NullPointerException {
        AngriffPruefer angriffePruefer = new AngriffPruefer();
        List<List<Angriff>> gruppen = AngriffListe.gruppiereAngriffe(angriffe);
        for (List<Angriff> gruppe : gruppen) {
            Euro einheitlicherAntrag = AngriffListe.findeEinheitlichenAntrag(gruppe);
            for (Angriff angriff : gruppe) {
                angriffePruefer.pruefeEingabe(angriff);
                if (einheitlicherAntrag.getCents() < 0L || angriff.getGegner().size() != 1 || AngriffListe.findeGanzenErfolg(gruppe, (List<Beteiligter>)angriff.getAngreifer(), (List<Beteiligter>)angriff.getGegner()).getCents() <= einheitlicherAntrag.getCents()) continue;
                throw new IllegalArgumentException("Die gesamtschuldnerische Verurteilung und die Verurteilung dar\u00fcber hinaus d\u00fcrfen zusammen nicht den Antrag \u00fcberschreiten.");
            }
        }
        return true;
    }
}

