/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.Angriff;
import eu.gronos.kostenrechner.interfaces.Pruefend;

public class AngriffPruefer
implements Pruefend<Angriff> {
    @Override
    public boolean pruefeEingabe(Angriff angriff) throws IllegalArgumentException, NullPointerException {
        if (angriff.getAngreifer() == null || angriff.getGegner() == null) {
            throw new NullPointerException("Liste der Angreifer/Gegner darf nicht null sein!");
        }
        if (angriff.getAngreifer().isEmpty() || angriff.getGegner().isEmpty()) {
            throw new IllegalArgumentException("Liste der Angreifer/Gegner darf nicht leer sein!");
        }
        if (angriff.getAntrag().getCents() < 0L || angriff.getErfolg().getCents() < 0L) {
            throw new IllegalArgumentException("Antrag/Erfolg darf nicht negativ sein!");
        }
        if (angriff.getGegner().size() > 1) {
            if (angriff.getAntrag().getCents() != 0L) {
                throw new IllegalArgumentException("Bei Gegner-Mehrheit muss der Antrag = 0 sein!");
            }
        } else if (angriff.getAntrag().getCents() < angriff.getErfolg().getCents()) {
            throw new IllegalArgumentException("Bei einfachem Gegner darf der Erfolg (" + angriff.getErfolg() + ") nicht \u00fcber den Antrag (" + angriff.getAntrag() + ") hinausgehen!");
        }
        return true;
    }
}

