/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.Pruefend;

public class GesamtschuldPruefer
implements Pruefend<BaumbachGesamtschuldnerschaft> {
    private static final String FEHLER_UNTERLIEGEN_GROESSER_STREITWERT = "Die gesamtschuldnerische Verurteilung (%,.2f EUR) darf zusammen mit der Verurteilung %s %ndar\u00fcber hinaus (%,.2f EUR) den Streitwert (%,.2f EUR) nicht \u00fcberschreiten!";
    private static final String FEHLER_NIX_GENUG_BETEILIGTE = "Nicht genug Beteiligte ausgew\u00e4hlt. W\u00e4hlen Sie mindestens zwei Beteiligte aus!";

    @Override
    public boolean pruefeEingabe(BaumbachGesamtschuldnerschaft eingabe) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        if (eingabe.getAufzaehlung() == null || eingabe.getAufzaehlung().length < 2) {
            throw new NullPointerException(FEHLER_NIX_GENUG_BETEILIGTE);
        }
        int[] nArray = eingabe.getAufzaehlung();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (eingabe.getBaumbachBeteiligtenListe().get(index) instanceof BaumbachGesamtschuldnerschaft) {
                throw new IllegalArgumentException("Sie d\u00fcrfen keine Gesamtschuldnerschaften ausw\u00e4hlen!");
            }
            if (eingabe.getErfolg().add(((BaumbachBeteiligter)eingabe.getBaumbachBeteiligtenListe().get(index)).getErfolg()).greaterThan(((BaumbachBeteiligter)eingabe.getBaumbachBeteiligtenListe().get(index)).getAntrag())) {
                throw new IllegalArgumentException(String.format(FEHLER_UNTERLIEGEN_GROESSER_STREITWERT, eingabe.getErfolg(), eingabe.getBaumbachBeteiligtenListe().parteiBezeichner(Beteiligter.Casus.GENITIV, index), ((BaumbachBeteiligter)eingabe.getBaumbachBeteiligtenListe().get(index)).getErfolg(), ((BaumbachBeteiligter)eingabe.getBaumbachBeteiligtenListe().get(index)).getAntrag()));
            }
            ++n2;
        }
        return true;
    }
}

