/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.baumbach.BeteiligtenPruefer;
import eu.gronos.kostenrechner.util.baumbach.GesamtschuldPruefer;

public class StreitgenossenPruefer
implements Pruefend<Streitgenossen> {
    @Override
    public boolean pruefeEingabe(Streitgenossen eingabe) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        if (eingabe.klaeger == null || eingabe.klaeger.isEmpty()) {
            throw new IllegalArgumentException("Die BaumbachBeteiligtenListe baumbachBeteiligtenListe muss mindestens einen KLAEGER und einen BEKLAGTEn enthalten!");
        }
        if (eingabe.beklagte == null || eingabe.beklagte.isEmpty()) {
            throw new IllegalArgumentException("Die BaumbachBeteiligtenListe baumbachBeteiligtenListe muss mindestens einen KLAEGER und einen BEKLAGTEn enthalten!");
        }
        if (eingabe.klaeger.zaehleKlaeger() > 1 || eingabe.beklagte.zaehleAnWiderklageBeteiligte() > 1) {
            throw new IllegalArgumentException("Derzeit wird nicht mehr als ein Kl\u00e4ger bzw. ein widerklagender Beklagter unterst\u00fctzt.");
        }
        if (eingabe.klaeger.zaehleBeklagte() > 0 || eingabe.klaeger.zaehleDrittwiderbeklagte() > 0 || eingabe.beklagte.zaehleKlaeger() > 0 || eingabe.beklagte.zaehleDrittwiderbeklagte() > 0 || eingabe.drittwiderbeklagte.zaehleKlaeger() > 0 || eingabe.drittwiderbeklagte.zaehleBeklagte() > 0) {
            throw new IllegalArgumentException("Die Beteiligten m\u00fcssen in der Reihenfolge Kl\u00e4ger, Drittwiderbeklagte (sofern vorhanden), Beklagte \u00fcbergeben werden. \nBitte Programmierer benachrichtigen!");
        }
        if (eingabe.beklagte.zaehleAnWiderklageBeteiligte() > 0 && eingabe.klaeger.zaehleAnWiderklageBeteiligte() + eingabe.drittwiderbeklagte.zaehleAnWiderklageBeteiligte() <= 0) {
            throw new IllegalArgumentException("Es wurde ein widerklagender Beklagter, aber kein widerbeklagter Kl\u00e4ger / Drittwiderbeklagter gefunden.");
        }
        if (eingabe.beklagte.zaehleAnWiderklageBeteiligte() <= 0 && eingabe.klaeger.zaehleAnWiderklageBeteiligte() + eingabe.drittwiderbeklagte.zaehleAnWiderklageBeteiligte() > 0) {
            throw new IllegalArgumentException("Es wurden widerbeklagte Kl\u00e4ger / Drittwiderbeklagte, aber kein widerklagender Beklagter gefunden.");
        }
        BeteiligtenPruefer betPruefer = new BeteiligtenPruefer();
        GesamtschuldPruefer gesPruefer = new GesamtschuldPruefer();
        BaumbachBeteiligtenListe[] baumbachBeteiligtenListeArray = new BaumbachBeteiligtenListe[]{eingabe.klaeger, eingabe.beklagte, eingabe.drittwiderbeklagte};
        int n = baumbachBeteiligtenListeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaumbachBeteiligtenListe liste = baumbachBeteiligtenListeArray[n2];
            for (BaumbachBeteiligter beteiligter : liste) {
                if (beteiligter instanceof BaumbachGesamtschuldnerschaft) {
                    gesPruefer.pruefeEingabe((BaumbachGesamtschuldnerschaft)beteiligter);
                    continue;
                }
                betPruefer.pruefeEingabe(beteiligter);
            }
            ++n2;
        }
        return true;
    }
}

