/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.files;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.RtfWerkzeugKasten;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class TenorXmlDatei
extends BerechnungXmlDatei {
    private static final String FEHLER_BEIM_KONVERTIEREN_IN_XML = "Programmzust\u00e4nde konnten nicht in XML konvertiert werden: ";
    private static final String SCHEMA_LOCATION = "https://www.kostentenor.de schema-tenordaten.xsd";

    @Override
    public String toXmlString(VerfahrensDatenContainer container) {
        if (!(container instanceof TenorDatenContainer)) {
            return super.toXmlString(container);
        }
        StringWriter sw = new StringWriter();
        try {
            Marshaller marshaller = TenorXmlDatei.createMarshaller(false, this.getSchemaLocation());
            marshaller.marshal((Object)container, sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return FEHLER_BEIM_KONVERTIEREN_IN_XML + e.getLocalizedMessage();
        }
        return sw.toString();
    }

    @Override
    public void speicherXml(VerfahrensDatenContainer container, Path datei) throws JAXBException, IOException {
        if (!(container instanceof TenorDatenContainer)) {
            super.speicherXml(container, datei);
        }
        Marshaller marshaller = TenorXmlDatei.createMarshaller(true, this.getSchemaLocation());
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream out = Files.newOutputStream(datei, new OpenOption[0]);){
            marshaller.marshal((Object)container, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public VerfahrensDatenContainer ladeXml(Path datei) {
        TenorDatenContainer container = null;
        try {
            Kostenrechner.getLogger().info("TenorXmlDatei#ladeXml");
            container = this.unmarshalXml(datei);
            if (container == null || (container.hauptsacheEntscheidung.isEmpty() || container.kostenEntscheidung.isEmpty() || container.vollstreckbarkeitsEntscheidung.isEmpty()) && container.sonstigeEntscheidung.isEmpty()) {
                throw new NullPointerException("Kein TenorDatenContainer oder veraltetes Format!");
            }
            Kostenrechner.getLogger().info(String.format("Geladen als tdc: %s (%s)", datei.toAbsolutePath(), container.getClass()));
        }
        catch (Exception error) {
            error.printStackTrace();
            return super.ladeXml(datei);
        }
        if (container != null) {
            container.streitgenossen = this.fixGesamtschuldnerschaften(container.streitgenossen);
        }
        return container;
    }

    @Override
    public String getDateiendung() {
        return "skktx";
    }

    @Override
    public String getSchemaLocation() {
        return SCHEMA_LOCATION;
    }

    public static BerechnungXmlDatei createInstanceFor(Path datei) {
        if (TenorXmlDatei.isTenorXmlEndung(datei)) {
            return new TenorXmlDatei();
        }
        return new BerechnungXmlDatei();
    }

    private TenorDatenContainer unmarshalXml(Path datei) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance(TenorDatenContainer.class);
        Unmarshaller u = context.createUnmarshaller();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = Files.newInputStream(datei, new OpenOption[0]);){
            return (TenorDatenContainer)u.unmarshal(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Marshaller createMarshaller(boolean formattedOutput, String schemaLocation) throws JAXBException, PropertyException {
        JAXBContext context = JAXBContext.newInstance(TenorDatenContainer.class);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", new Boolean(formattedOutput));
        marshaller.setProperty("jaxb.schemaLocation", schemaLocation);
        return marshaller;
    }

    private static boolean isTenorXmlEndung(Path datei) {
        return datei != null && datei.getFileName().toString().toLowerCase().endsWith(String.valueOf(RtfWerkzeugKasten.DATEI_FILTER.ganzeEndung()) + DATEI_FILTER.ganzeEndung());
    }
}

