/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.files;

import eu.gronos.kostenrechner.Kostenrechner;
import java.util.logging.Level;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XJustizErrorHandler
implements ErrorHandler {
    private String getParseExceptionInfo(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = "URI=" + systemId + "Line=" + spe.getLineNumber() + ":" + spe.getLocalizedMessage() + " (" + spe.getMessage() + ")";
        return info;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        Kostenrechner.getLogger().log(Level.WARNING, String.format("Warnung: %s", this.getParseExceptionInfo(spe)), spe);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        String message = "Error: " + this.getParseExceptionInfo(spe);
        System.err.println(message);
        throw new SAXException(message);
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        String message = String.format("Fatal Error: %s", this.getParseExceptionInfo(spe));
        Kostenrechner.getLogger().log(Level.SEVERE, message, spe);
        throw new SAXException(message);
    }
}

