/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.BerechnungXmlDatei;
import eu.gronos.kostenrechner.util.files.TenorXmlDatei;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.bind.JAXBException;

public class BerechnungFileChooser
extends KostenFileChooser {
    private static final long serialVersionUID = 5816976530887334541L;

    public BerechnungFileChooser(Beschriftung beschriftung) {
        super(BerechnungXmlDatei.DATEI_FILTER, beschriftung);
    }

    public int showSaveDialog(Component parent, VerfahrensDatenContainer container) {
        int option = super.showSaveDialog(parent);
        BerechnungXmlDatei berechnungXml = new BerechnungXmlDatei();
        if (option == 0) {
            try {
                Path datei = this.getSelectedPath();
                berechnungXml.speicherXml(container, datei);
                Kostenrechner.getLogger().info(String.format("Gespeichert: %s", datei.toAbsolutePath()));
            }
            catch (IOException | JAXBException jioe) {
                option = -1;
                FehlerHelper.zeigeFehler("Fehler beim Speichern als XML!", jioe);
            }
        }
        return option;
    }

    public VerfahrensDatenContainer ladeXmlDialog(Component parent) {
        VerfahrensDatenContainer container = null;
        int option = super.showOpenDialog(parent);
        if (option == 0) {
            Path datei = this.getSelectedPath();
            BerechnungXmlDatei berechnungXml = TenorXmlDatei.createInstanceFor(datei);
            container = berechnungXml.ladeXml(datei);
        }
        return container;
    }
}

