/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;

public class EuroEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -7511642419428646152L;

    public EuroEditor(NumberFormatter formatter) {
        super(new JFormattedTextField(formatter));
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        ftf.setHorizontalAlignment(11);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        final JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        String textValue = value.toString();
        if (value instanceof String) {
            textValue = (String)value;
        } else if (value instanceof Double) {
            textValue = Double.toString((Double)value);
        }
        ftf.setText(textValue);
        ftf.selectAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ftf.setCaretPosition(0);
                ftf.selectAll();
                ftf.requestFocus();
            }
        });
        return ftf;
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
                return super.stopCellEditing();
            }
            catch (ParseException e) {
                FehlerHelper.zeigeFehler("Falsches Eingabeformat! " + e.getLocalizedMessage(), e);
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object value = ftf.getValue();
        System.out.println(value);
        if (value instanceof Double) {
            return Euro.ofEuros((Double)value);
        }
        if (value instanceof Number) {
            return Euro.ofEuros(((Number)value).doubleValue());
        }
        return null;
    }
}

