/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.KostenTableRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class EuroRenderer
extends KostenTableRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -855994687899724408L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.isGesamtschuldnerStreitwert(table, row, column)) {
            this.setText("gesamtschuldnerisch");
        } else if (value != null) {
            if (value instanceof Double) {
                this.setText(String.format("%,.2f EUR", value));
            } else if (value instanceof Long) {
                long longValue = (Long)value;
                this.setText(String.format("%,.2f EUR", longValue));
            } else {
                this.setText(value.toString());
            }
        } else {
            this.setText("");
        }
        this.setHorizontalAlignment(4);
        this.setSelected(isSelected);
        if (table.isPaintingForPrint()) {
            this.setText(String.valueOf(this.getText()) + "\t ");
        }
        return this;
    }

    private boolean isGesamtschuldnerStreitwert(JTable table, int row, int column) {
        return table.getModel() instanceof BeteiligtenTableModel && table.getModel().getValueAt(row, 0) instanceof BaumbachGesamtschuldnerschaft && column == 1;
    }
}

