/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.controller.system.MacAboutHandler;
import eu.gronos.kostenrechner.controller.system.MacDockIcon;
import eu.gronos.kostenrechner.controller.system.MacOpenFileHandler;
import eu.gronos.kostenrechner.controller.system.MacQuitHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class OsLookAndFeelChanger {
    private OsLookAndFeelChanger() {
    }

    public static void pruefeOS() {
        if (OsLookAndFeelChanger.isWin()) {
            OsLookAndFeelChanger.setWindowsLookAndFeel();
        }
        if (OsLookAndFeelChanger.isMac()) {
            OsLookAndFeelChanger.setMacOsLookAndFeel();
        }
    }

    public static void setMacOsLookAndFeel() {
        try {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", ((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(100)).getTitle());
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
            MacDockIcon.dockIconSetzen();
            MacAboutHandler.aboutMenuSetzen();
            MacQuitHandler.quitSetzen();
            MacOpenFileHandler.fileHandlerSetzen();
        }
        catch (ClassNotFoundException | IllegalAccessError | IllegalAccessException | InstantiationException | NoClassDefFoundError | UnsupportedLookAndFeelException e1) {
            FehlerHelper.zeigeFehler("Fehler beim Anpassen an Apple MacOS:\n" + e1.getLocalizedMessage(), e1);
        }
        Kostenrechner.ctrlMask = 256;
    }

    public static void setWindowsLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
            FehlerHelper.zeigeFehler(e1.getLocalizedMessage(), e1);
        }
    }

    public static boolean isMac() {
        return System.getProperty("os.name").contains("Mac OS X");
    }

    public static boolean isWin() {
        return System.getProperty("os.name").contains("Windows") && "\\".equals(System.getProperty("file.separator"));
    }
}

