/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.beschriftungen.view.TabbedPaneFactory;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.baumbach.AssistentBkStreitwertHorcher;
import eu.gronos.kostenrechner.controller.baumbach.AssistentBkUnterliegenHorcher;
import eu.gronos.kostenrechner.controller.baumbach.AssistentWbkStreitwertHorcher;
import eu.gronos.kostenrechner.controller.baumbach.AssistentWbkUnterliegenHorcher;
import eu.gronos.kostenrechner.controller.baumbach.AssistentWeiterAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenAssistentParser;
import eu.gronos.kostenrechner.controller.files.HtmlWerkzeugKasten;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.tenordaten.Allgemein;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.ProtoBeteiligtenWerte;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenListRenderer;
import eu.gronos.kostenrechner.view.baumbach.SimpleBeteiligtenTable;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public class BaumbachAssistentDialog
extends HinzufuegenDialog<VerfahrensDatenContainer> {
    private static final long serialVersionUID = -170526643502912253L;
    private JTabbedPane tabbedPane;
    private JPanel[] panels;
    private VerfahrensDatenContainer verfahrensDatenContainer;
    private JTextPane textPane;
    private JSpinner spiKlaegerZahl;
    private JTable tabKlaegerGenus;
    private SimpleBeteiligtenTable tabBeklagtenGenus;
    private JCheckBox chbBkSwEinheitlich;
    private JFormattedTextField ftfBkStreitwert;
    private SimpleBeteiligtenTable tabBeklagtenSw;
    private JCheckBox chBkGesamtschuldner;
    private JList<Beteiligter> liBkGesamtschuldner;
    private JFormattedTextField ftfBkGesamtUnterliegen;
    private SimpleBeteiligtenTable tbBkUnt;
    private JList<Beteiligter> liBkWk;
    private SimpleBeteiligtenTable tbDwbkGenus;
    private JCheckBox chbWkEinheitlich;
    private JFormattedTextField ftfWkSw;
    private SimpleBeteiligtenTable tabKlSw;
    private SimpleBeteiligtenTable tabDwbkSw;
    private JCheckBox chbWkGesamtschuld;
    private JList<Beteiligter> liWkGesamtschuldner;
    private JFormattedTextField ftfWkUnterliegen;
    private SimpleBeteiligtenTable tbKlDarueber;
    private JScrollPane scpKlDarueber;
    private SimpleBeteiligtenTable tbDwbkDarueber;
    public final ProtoBeteiligtenWerte primitives;
    private final ParsendUndBauend<Streitgenossen> pruefer = new StreitgenossenAssistentParser();
    private AbstractAction weiter = new AssistentWeiterAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38011), this.pruefer);

    public BaumbachAssistentDialog(JFrame owner, boolean mitWiderklage) {
        super((Window)owner, (VorsorgendeBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38000));
        this.primitives = new ProtoBeteiligtenWerte();
        this.primitives.mitWiderklage = mitWiderklage;
        ((StreitgenossenAssistentParser)this.pruefer).setZustand(0);
        this.setContainer(null);
        this.primitives.ohneXjustiz = this.getVerfahrensDatenContainer() == null;
        this.setOkButtonToBeFocussed(false);
        Kostenrechner.getLogger().info("BaumbachAssistentDialog - ohne Xjustiz!");
        ((StreitgenossenAssistentParser)this.pruefer).setRueckgabewert(new Streitgenossen());
        ((StreitgenossenAssistentParser)this.pruefer).setPrimitives(this.primitives);
    }

    public BaumbachAssistentDialog(JFrame owner, VerfahrensDatenContainer container) {
        super((Window)owner, (Beschriftung)((Object)new ComponentBeschrifter().changeTo((Vorsorgend)((Object)NameContainerSammlung.BESCHRIFTUNGEN.get(38000)), 1)));
        this.primitives = ((StreitgenossenAssistentParser)this.pruefer).pruefeVerfahrensDatenContainer(container, new ProtoBeteiligtenWerte());
        ((StreitgenossenAssistentParser)this.pruefer).setZustand(0);
        this.setContainer(container);
        this.setOkButtonToBeFocussed(false);
        Kostenrechner.getLogger().info("BaumbachAssistentDialog - mit Xjustiz!");
        ((StreitgenossenAssistentParser)this.pruefer).setRueckgabewert(container.streitgenossen);
        ((StreitgenossenAssistentParser)this.pruefer).setPrimitives(this.primitives);
    }

    public void zustandAnzeigen(int index) {
        int i = 0;
        while (i < ((StreitgenossenAssistentParser)this.pruefer).getHoechsterZustand() && this.panels[i] != null) {
            if (i == 0) {
                this.tabbedPane.setEnabledAt(i, true);
            } else if (i == index) {
                this.tabbedPane.setEnabledAt(i, true);
                this.tabbedPane.setSelectedIndex(i);
            } else {
                this.tabbedPane.setEnabledAt(i, false);
            }
            ++i;
        }
        if (index < ((StreitgenossenAssistentParser)this.pruefer).getHoechsterZustand() - 1) {
            super.getOkButton().requestFocusInWindow();
        } else {
            this.restoreOkButton();
            super.getOkButton().requestFocusInWindow();
        }
    }

    @Override
    public boolean parseEingabe() {
        Kostenrechner.getLogger().info(String.format("Zustand: %d", ((StreitgenossenAssistentParser)this.pruefer).getZustand()));
        boolean boole = false;
        try {
            boole = this.pruefer.parseEingabe();
        }
        catch (IllegalArgumentException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            boole = false;
        }
        catch (NullPointerException e) {
            FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            boole = false;
        }
        return boole;
    }

    public VerfahrensDatenContainer getVerfahrensDatenContainer() {
        return this.verfahrensDatenContainer;
    }

    @Override
    protected VerfahrensDatenContainer baueRueckgabewert() {
        VerfahrensDatenContainer c = new VerfahrensDatenContainer();
        c.streitgenossen = this.pruefer.getRueckgabewert();
        Allgemein a = c.allgemein;
        a.speicherdatum = new XmlTransferHandler().speicherDatum();
        a.aktenzeichen = !this.primitives.ohneXjustiz ? this.getVerfahrensDatenContainer().allgemein.aktenzeichen : "";
        a.streitwert = this.primitives.wkStreitwert.greaterThan(this.primitives.bkStreitwert) ? this.primitives.wkStreitwert : this.primitives.bkStreitwert;
        a.selectedPanel = 1;
        Kostenrechner.getLogger().info(this.primitives.toString());
        return c;
    }

    @Override
    protected void setContentPanel() {
        this.tabbedPane = new JTabbedPane(1);
        ComponentBeschrifter beschrifter = new ComponentBeschrifter();
        beschrifter.beschrifte(this.tabbedPane, NameContainerSammlung.BESCHRIFTUNGEN.get(38001));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setBorder(BORDER);
        this.panels = new JPanel[11];
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i] = new JPanel();
            this.panels[i].setBorder(BORDER);
            this.panels[i].setLayout(new GridBagLayout());
            ++i;
        }
    }

    @Override
    protected void fuelleContentPane() {
        this.baueWeiterButton();
        int[] keys = new int[]{38002, 38020, 38100, 38200, 38300, 38400, 38500, 38600, 38700, 38800, 38900};
        int i = 0;
        while (i < this.panels.length && (this.primitives.mitWiderklage || i < 6)) {
            Beschriftung beschriftung = (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(keys[i]);
            TabbedPaneFactory.intoTabbedPane(this.tabbedPane, this.panels[i], beschriftung);
            ++i;
        }
        HtmlWerkzeugKasten kit = new HtmlWerkzeugKasten();
        this.textPane = (JTextPane)this.beschrifter.beschrifteVergittert(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(38005), this.panels[0]);
        this.textPane.setEditorKit(kit);
        kit.read(this.willkommenRessource(), this.textPane);
        if (!this.primitives.ohneXjustiz) {
            this.baueAzEin(this.textPane, this.getVerfahrensDatenContainer().allgemein.aktenzeichen);
        }
        this.spiKlaegerZahl = (JSpinner)this.beschrifter.beschrifteGemeinsam(new JSpinner(), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38025), this.panels[1]);
        this.spiKlaegerZahl.setEnabled(false);
        this.beschrifter.beschrifteGemeinsam(new JSpinner(), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38035), this.panels[1]);
        this.tabKlaegerGenus = (JTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.KLAEGER), NameContainerSammlung.BESCHRIFTUNGEN.get(38111));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tabKlaegerGenus), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38110), this.panels[2]);
        this.tabBeklagtenGenus = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.BEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38131));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tabBeklagtenGenus), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38130), this.panels[2]);
        this.chbBkSwEinheitlich = (JCheckBox)this.beschrifter.beschrifteVergittert(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(38201), this.panels[3]);
        this.ftfBkStreitwert = (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38215), this.panels[3]);
        this.setEnterAction(this.ftfBkStreitwert, this.weiter);
        this.tabBeklagtenSw = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.BEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38221));
        this.chbBkSwEinheitlich.addChangeListener(new AssistentBkStreitwertHorcher(this.ftfBkStreitwert, this.tabBeklagtenSw));
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabBeklagtenSw), NameContainerSammlung.BESCHRIFTUNGEN.get(38220), this.panels[3]);
        this.chBkGesamtschuldner = (JCheckBox)this.beschrifter.beschrifteVergittert(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(38301), this.panels[4]);
        this.chBkGesamtschuldner.setSelected(true);
        this.liBkGesamtschuldner = new JList();
        this.beschrifter.beschrifte(this.liBkGesamtschuldner, NameContainerSammlung.BESCHRIFTUNGEN.get(38321));
        this.liBkGesamtschuldner.setSelectionMode(2);
        this.liBkGesamtschuldner.setCellRenderer(new BeteiligtenListRenderer(false));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.liBkGesamtschuldner), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38320), this.panels[4]);
        this.beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(38331), this.panels[4]);
        this.ftfBkGesamtUnterliegen = (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38335), this.panels[4]);
        this.setEnterAction(this.ftfBkGesamtUnterliegen, this.weiter);
        this.chBkGesamtschuldner.addChangeListener(new AssistentBkUnterliegenHorcher(this.liBkGesamtschuldner, this.ftfBkGesamtUnterliegen));
        this.tbBkUnt = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.BEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38411));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tbBkUnt), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38410), this.panels[5]);
        if (!this.primitives.mitWiderklage) {
            this.zustandAnzeigen(((StreitgenossenAssistentParser)this.pruefer).getZustand());
            this.panelsAusblendenBeiImport();
            return;
        }
        this.liBkWk = new JList();
        this.beschrifter.beschrifte(this.liBkWk, NameContainerSammlung.BESCHRIFTUNGEN.get(38511));
        this.liBkWk.setCellRenderer(new BeteiligtenListRenderer());
        this.liBkWk.setSelectionMode(0);
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.liBkWk), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38510), this.panels[6]);
        this.beschrifter.beschrifteGemeinsam(new JSpinner(), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38525), this.panels[6]);
        this.beschrifter.beschrifteVergittert(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(38531), this.panels[6]);
        this.tbDwbkGenus = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38611));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tbDwbkGenus), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38610), this.panels[7]);
        this.chbWkEinheitlich = (JCheckBox)this.beschrifter.beschrifteVergittert(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(38701), this.panels[8]);
        this.ftfWkSw = (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38715), this.panels[8]);
        this.setEnterAction(this.ftfWkSw, this.weiter);
        this.tabKlSw = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.KLAEGER), NameContainerSammlung.BESCHRIFTUNGEN.get(38731));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tabKlSw), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38730), this.panels[8]);
        this.tabDwbkSw = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38751));
        this.chbWkEinheitlich.addChangeListener(new AssistentWbkStreitwertHorcher(this.ftfWkSw, this.tabKlSw, this.tabDwbkSw, this.primitives));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tabDwbkSw), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38750), this.panels[8]);
        this.chbWkGesamtschuld = (JCheckBox)this.beschrifter.beschrifteVergittert(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(38801), this.panels[9]);
        JLabel lblWkGesamtschuldner = (JLabel)this.beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(38811), this.panels[9]);
        this.liWkGesamtschuldner = new JList();
        this.beschrifter.beschrifte(this.liWkGesamtschuldner, NameContainerSammlung.BESCHRIFTUNGEN.get(38821));
        this.liWkGesamtschuldner.setCellRenderer(new BeteiligtenListRenderer());
        lblWkGesamtschuldner.setLabelFor(this.liWkGesamtschuldner);
        this.liWkGesamtschuldner.setSelectionMode(2);
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.liWkGesamtschuldner), NameContainerSammlung.BESCHRIFTUNGEN.get(38820), this.panels[9]);
        this.ftfWkUnterliegen = (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38835), this.panels[9]);
        this.chbWkGesamtschuld.addChangeListener(new AssistentWbkUnterliegenHorcher(this.liWkGesamtschuldner, this.ftfWkUnterliegen, this.primitives));
        this.setEnterAction(this.ftfWkUnterliegen, this.weiter);
        JLabel lblKlDarueber = (JLabel)this.beschrifter.beschrifteVergittert(new JLabel(), NameContainerSammlung.BESCHRIFTUNGEN.get(38901), this.panels[10]);
        this.tbKlDarueber = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.KLAEGER), NameContainerSammlung.BESCHRIFTUNGEN.get(38911));
        this.scpKlDarueber = (JScrollPane)this.beschrifter.beschrifteVergittert(new JScrollPane(this.tbKlDarueber), NameContainerSammlung.BESCHRIFTUNGEN.get(38910), this.panels[10]);
        lblKlDarueber.setLabelFor(this.scpKlDarueber);
        this.tbDwbkDarueber = (SimpleBeteiligtenTable)this.beschrifter.beschrifte(new SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE), NameContainerSammlung.BESCHRIFTUNGEN.get(38931));
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tbDwbkDarueber), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(38930), this.panels[10]);
        this.zustandAnzeigen(((StreitgenossenAssistentParser)this.pruefer).getZustand());
        this.panelsAusblendenBeiImport();
    }

    private String willkommenRessource() {
        if (!this.primitives.ohneXjustiz) {
            return "resources/assistent-xjustiz.html";
        }
        return "resources/assistent.html";
    }

    private void baueAzEin(JTextPane jta, String aktenzeichen) {
        HTMLDocument htmlDoc = (HTMLDocument)jta.getDocument();
        Element span = htmlDoc.getElement("az");
        if (span != null) {
            try {
                System.err.println(htmlDoc.getText(span.getStartOffset(), span.getEndOffset() - span.getStartOffset()));
                htmlDoc.remove(span.getStartOffset(), span.getEndOffset() - span.getStartOffset());
                htmlDoc.insertString(span.getStartOffset(), " dem Verfahren " + aktenzeichen, span.getAttributes());
            }
            catch (BadLocationException e) {
                FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
            }
        } else {
            System.err.println("Nix kann writen Aktenzeichen!");
        }
    }

    private void restoreOkButton() {
        super.getOkButton().setAction(super.getOkAction());
        super.setOkActionEnabled(true);
        this.removeFromInputMap(this.weiter);
        this.addToRootInputMap(super.getOkAction());
        this.beschrifter.beschrifte(super.getOkButton(), NameContainerSammlung.BESCHRIFTUNGEN.get(76051));
    }

    private void baueWeiterButton() {
        super.setOkActionEnabled(false);
        this.removeFromInputMap(this.getOkAction());
        super.getOkButton().setAction(this.weiter);
        this.addToRootInputMap(this.weiter);
        this.beschrifter.beschrifte(super.getOkButton(), NameContainerSammlung.BESCHRIFTUNGEN.get(38011));
    }

    private void panelsAusblendenBeiImport() {
        if (this.primitives.ohneXjustiz) {
            return;
        }
        if (this.primitives.tab1ueberspringen) {
            this.panels[1].setVisible(false);
            this.tabbedPane.setTitleAt(1, null);
        }
        if (this.primitives.tab2ueberspringen) {
            this.panels[2].setVisible(false);
            this.tabbedPane.setTitleAt(2, null);
        }
        if (this.primitives.tab4ueberspringen) {
            this.panels[4].setVisible(false);
            this.tabbedPane.setTitleAt(4, null);
        }
        if (this.primitives.mitWiderklage) {
            if (this.primitives.tab6ueberspringen) {
                this.tabbedPane.setTitleAt(6, null);
                this.panels[6].setVisible(false);
            }
            if (this.primitives.tab7ueberspringen) {
                this.tabbedPane.setTitleAt(7, null);
                this.panels[7].setVisible(false);
            }
            if (this.primitives.tab9ueberspringen) {
                this.tabbedPane.setTitleAt(9, null);
                this.panels[9].setVisible(false);
            }
        }
    }

    private void setContainer(VerfahrensDatenContainer container) {
        this.verfahrensDatenContainer = container;
    }
}

