/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.KostenTableRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BeteiligtenTableRenderer
extends KostenTableRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -7430326486747341015L;
    private final boolean laufendeNummerImmerAusblenden;

    public BeteiligtenTableRenderer(boolean laufendeNummerImmerAusblenden) {
        this.laufendeNummerImmerAusblenden = laufendeNummerImmerAusblenden;
    }

    public BeteiligtenTableRenderer() {
        this(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof BaumbachGesamtschuldnerschaft) {
            BaumbachGesamtschuldnerschaft bgs = (BaumbachGesamtschuldnerschaft)value;
            this.setText(bgs.kurzBezeichner(Beteiligter.Casus.NOMINATIV).replace("gesamtschuldnerisch", ""));
            this.setToolTipText(bgs.parteiBezeichner(Beteiligter.Casus.NOMINATIV, -1, true));
        } else if (value instanceof BaumbachBeteiligter && table.getModel() instanceof BeteiligtenTableModel) {
            BaumbachBeteiligtenListe bbtl = ((BeteiligtenTableModel)table.getModel()).getAllValues();
            this.setText(bbtl.parteiBezeichner(Beteiligter.Casus.NOMINATIV, row));
            this.setToolTipText(bbtl.parteiBezeichner(Beteiligter.Casus.NOMINATIV, row));
        } else if (value instanceof Beteiligter) {
            Beteiligter b = (Beteiligter)value;
            boolean einzigerSeinerArt = this.laufendeNummerImmerAusblenden ? this.laufendeNummerImmerAusblenden : table.getRowCount() < 2;
            this.setText(b.parteiBezeichner(Beteiligter.Casus.NOMINATIV, row + 1, einzigerSeinerArt));
            this.setToolTipText(b.parteiBezeichner(Beteiligter.Casus.NOMINATIV, row + 1, einzigerSeinerArt));
        }
        this.setSelected(isSelected);
        return this;
    }
}

