/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.kostenrechner.controller.baumbach.GesamtschuldParser;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenExtractAndCancelAction;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenListModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenListRenderer;
import java.awt.Window;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class GesamtschuldnerDialog
extends HinzufuegenDialog<BaumbachGesamtschuldnerschaft> {
    private static final long serialVersionUID = 7906671533792996231L;
    private final BeschriebeneAktion extrahierenAction;
    private BaumbachBeteiligtenListe baumbachBeteiligtenListe;
    private JList<BaumbachBeteiligter> beteiligtenAuswahlListe;
    private JFormattedTextField ftfUnterliegen;
    private ParsendUndBauend<BaumbachGesamtschuldnerschaft> pruefer = new GesamtschuldParser();

    public GesamtschuldnerDialog(JFrame owner, BaumbachBeteiligtenListe kl, BaumbachBeteiligtenListe dwbk, BeschriebeneAktion extrahierenAction) {
        this(owner, new BaumbachBeteiligtenListe(kl, dwbk), extrahierenAction);
    }

    public GesamtschuldnerDialog(JFrame owner, BaumbachBeteiligtenListe baumbachBeteiligtenListe, BeschriebeneAktion extrahierenAction) throws IllegalArgumentException {
        super((Window)owner, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(36000));
        if (baumbachBeteiligtenListe.size() < 1) {
            throw new IllegalArgumentException("Keine Beteiligten f\u00fcr den angegebenen Beteiligtentyp vorhanden, \ndie gesamtschuldnerisch verurteilt werden k\u00f6nnten. \nBitte zun\u00e4chst \"einfache\" Beteiligte der Liste hinzuf\u00fcgen.");
        }
        this.baumbachBeteiligtenListe = baumbachBeteiligtenListe;
        LangBeschriftung beschriftung = (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(36031);
        beschriftung.setActionCommandKey((String)extrahierenAction.getValue("ActionCommandKey"));
        this.extrahierenAction = new StreitgenossenExtractAndCancelAction(beschriftung, extrahierenAction, super.getCancelAction());
    }

    @Override
    public boolean parseEingabe() {
        return this.pruefer.leseComponents(this.beteiligtenAuswahlListe, this.ftfUnterliegen).parseEingabe();
    }

    @Override
    protected BaumbachGesamtschuldnerschaft baueRueckgabewert() {
        return this.pruefer.leseComponents(this.beteiligtenAuswahlListe, this.ftfUnterliegen).getRueckgabewert();
    }

    @Override
    protected void fuelleContentPane() {
        this.beteiligtenAuswahlListe = new JList<BaumbachBeteiligter>(new BeteiligtenListModel(this.baumbachBeteiligtenListe));
        this.beschrifter.beschrifte(this.beteiligtenAuswahlListe, NameContainerSammlung.BESCHRIFTUNGEN.get(36011));
        this.beteiligtenAuswahlListe.setSelectionMode(2);
        this.beteiligtenAuswahlListe.setCellRenderer(new BeteiligtenListRenderer());
        this.togetherToContentPanel(new JScrollPane(this.beteiligtenAuswahlListe), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(36010));
        this.ftfUnterliegen = (JFormattedTextField)this.togetherToContentPanel(new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(36025));
        this.ftfUnterliegen.setText(this.getLetztenBeteiligten().getErfolg().toString());
        this.ftfUnterliegen.setColumns(10);
        this.setEnterAction(this.ftfUnterliegen, this.getOkAction());
        this.toButtonPanel(this.extrahierenAction);
    }

    private BaumbachBeteiligter getLetztenBeteiligten() {
        return (BaumbachBeteiligter)this.baumbachBeteiligtenListe.get(this.baumbachBeteiligtenListe.size() - 1);
    }
}

