/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.baumbach.ScalableBeteiligtenTableModel;
import eu.gronos.kostenrechner.view.EuroEditor;
import eu.gronos.kostenrechner.view.EuroRenderer;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenTableRenderer;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.text.NumberFormatter;

public class SimpleBeteiligtenTable
extends JTable {
    private static final long serialVersionUID = -8877232808960976183L;
    private static NumberFormat format = NumberFormat.getInstance();
    private static NumberFormatter formatter;
    private Beteiligter.BeteiligtenTyp beteiligtenTyp;

    static {
        format.setGroupingUsed(false);
        formatter = new NumberFormatter(format);
    }

    @Override
    public void setModel(TableModel dm) {
        super.setModel(dm);
        if (dm != null && dm instanceof ScalableBeteiligtenTableModel) {
            this.setEditors();
            this.setRenderers();
            this.setWidth();
        }
    }

    public void setSelectionModel() {
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
    }

    public void setWidth() {
        if (this.isEmpty()) {
            return;
        }
        int maxWidth = this.getColumnModel().getColumn(1).getWidth() / 2;
        if (maxWidth < this.getColumnModel().getColumn(1).getMinWidth()) {
            maxWidth = this.getColumnModel().getColumn(1).getMinWidth();
        }
        this.getColumnModel().getColumn(0).setMaxWidth(maxWidth);
    }

    protected SimpleBeteiligtenTable(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        this.beteiligtenTyp = beteiligtenTyp;
    }

    protected SimpleBeteiligtenTable(TableModel dm, Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        this(beteiligtenTyp);
        this.setModel(dm);
    }

    private void setEditors() {
        this.setDefaultEditor(Beteiligter.class, new BeteiligtenCellEditor(this.beteiligtenTyp));
        this.setDefaultEditor(Double.class, new EuroEditor(formatter));
    }

    private void setRenderers() {
        this.setDefaultRenderer(Beteiligter.class, new BeteiligtenTableRenderer());
        this.setDefaultRenderer(Double.class, new EuroRenderer());
    }

    private boolean isEmpty() {
        return this.getModel() == null || this.getModel().getRowCount() < 1;
    }
}

