/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WiderklageTableRendererEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final long serialVersionUID = 1449507097445915897L;
    private JToggleButton editorToggle = null;
    private final AllzweckHorcher EDITOR_STOPPER = new AllzweckHorcher(){

        @Override
        public void mouseEntered(MouseEvent me) {
            WiderklageTableRendererEditor.this.stopCellEditing();
        }

        @Override
        public void mouseExited(MouseEvent me) {
            WiderklageTableRendererEditor.this.stopCellEditing();
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            WiderklageTableRendererEditor.this.stopCellEditing();
        }
    };

    @Override
    public Object getCellEditorValue() {
        boolean b = this.editorToggle == null ? false : this.editorToggle.isSelected();
        return new Boolean(b);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorToggle = (JToggleButton)this.getTableCellRendererComponent(table, value, true, true, row, column);
        this.editorToggle.addMouseMotionListener(this.EDITOR_STOPPER);
        return this.editorToggle;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int width;
        if (!(value instanceof Boolean)) {
            return null;
        }
        boolean b = (Boolean)value;
        JToggleButton toggle = null;
        BeteiligtenTableModel btm = null;
        if (table.getModel() instanceof BeteiligtenTableModel) {
            btm = (BeteiligtenTableModel)table.getModel();
            toggle = btm.getBeteiligtenTyp() == Beteiligter.BeteiligtenTyp.BEKLAGTE ? new JRadioButton() : new JCheckBox();
        } else {
            return null;
        }
        toggle.setSelected(b);
        toggle.setText(null);
        toggle.setHorizontalAlignment(0);
        toggle.setOpaque(true);
        if (isSelected) {
            toggle.setBackground(table.getSelectionBackground());
            toggle.setForeground(table.getSelectionForeground());
        } else {
            toggle.setBackground(table.getBackground());
            toggle.setForeground(table.getForeground());
        }
        int height = toggle.getMinimumSize().height;
        if (table.getRowHeight(row) < (height -= table.getIntercellSpacing().height * 2)) {
            table.setRowHeight(row, height);
        }
        if ((width = toggle.getMinimumSize().width) < table.getTableHeader().getColumnModel().getColumn(column).getMinWidth()) {
            width = table.getTableHeader().getColumnModel().getColumn(column).getMinWidth();
        }
        table.getColumnModel().getColumn(column).setPreferredWidth(width);
        return toggle;
    }
}

