/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.forderungen;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.forderungen.ForderungNeuAction;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungParser;
import eu.gronos.kostenrechner.controller.forderungen.ForderungsStaffelungTenorAction;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.forderungen.ForderungenTableModel;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import eu.gronos.kostenrechner.view.forderungen.ForderungHinzufuegen;
import eu.gronos.kostenrechner.view.forderungen.ForderungenRenderer;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ForderungsStaffelungPanel
extends KostenJPanel
implements WerteLesbar<ForderungsStaffelung> {
    private static final long serialVersionUID = 1506079463701863627L;
    private static final ForderungsStaffelungPanel instance = new ForderungsStaffelungPanel();
    private Kostenrechner kostenrechner;
    public JComboBox<Beteiligter> cbAngriffsKlaeger;
    public AbstractAction neueForderungAction = new ForderungNeuAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(42021));
    public AbstractAction angriffsVerteidigungsmittelStaffelungAction = new ForderungsStaffelungTenorAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(43011));
    public JComboBox<Beteiligter> cbVerteidigungsBeklagter;
    public ForderungenTableModel ftm;
    public JTable tbForderungen;
    private static final ForderungenRenderer FORDERUNGEN_RENDERER = new ForderungenRenderer();
    private final ParsendUndBauend<ForderungsStaffelung> pruefer = new ForderungsStaffelungParser();

    private ForderungsStaffelungPanel() {
    }

    public static ForderungsStaffelungPanel getInstance() {
        return instance;
    }

    @Override
    public void buildPanel() {
        JPanel pnParteien = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(41000), new GridBagLayout());
        Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BeteiligtenTyp.KLAEGER, true);
        this.cbAngriffsKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
        this.beschrifter.beschrifteGemeinsam(this.cbAngriffsKlaeger, (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(41005), pnParteien);
        this.cbAngriffsKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
        Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BeteiligtenTyp.BEKLAGTE, true);
        this.cbVerteidigungsBeklagter = new JComboBox<Beteiligter>(bkBezeichnerListe);
        this.beschrifter.beschrifteGemeinsam(this.cbVerteidigungsBeklagter, (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(41015), pnParteien);
        this.cbVerteidigungsBeklagter.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
        JPanel pnForderungen = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(42000), new GridBagLayout());
        this.tbForderungen = (JTable)this.beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(42011));
        this.leereWerte();
        this.entferneTastaturFalle(this.tbForderungen);
        this.tbForderungen.setDefaultRenderer(Forderung.class, FORDERUNGEN_RENDERER);
        this.tbForderungen.setDefaultRenderer(Double.class, KostenJPanel.EURO_RENDERER);
        this.tbForderungen.setDefaultEditor(Double.class, KostenJPanel.EURO_EDITOR);
        JComboBox<Forderung> cbForderungen = new JComboBox<Forderung>(ForderungHinzufuegen.sammleForderungen());
        cbForderungen.setRenderer(FORDERUNGEN_RENDERER);
        this.tbForderungen.setDefaultEditor(Forderung.class, new DefaultCellEditor(cbForderungen));
        this.tbForderungen.getTableHeader().setDefaultRenderer(KostenJPanel.HEADER_RENDERER);
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tbForderungen), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(42010), pnForderungen);
        this.beschrifter.add((BeschriebeneAktion)this.neueForderungAction, (Container)pnForderungen);
        this.beschrifter.add((BeschriebeneAktion)this.angriffsVerteidigungsmittelStaffelungAction, (Container)this);
        PopupMenuBuilder builder = new PopupMenuBuilder();
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(44000), this.tbForderungen, new Integer[]{1}, (BeschriebeneAktion)this.neueForderungAction, (BeschriebeneAktion)this.eintragEntfernenAktion);
        this.logDauer();
    }

    @Override
    public void setzeWerte(ForderungsStaffelung container) {
        this.cbAngriffsKlaeger.setSelectedItem(container.parteien.get(0));
        this.cbVerteidigungsBeklagter.setSelectedItem(container.parteien.get(1));
        this.ftm = new ForderungenTableModel();
        this.ftm.setAllValues(container.forderungen);
        this.tbForderungen.setModel(this.ftm);
    }

    @Override
    public void leereWerte() {
        if (this.tbForderungen != null) {
            this.ftm = new ForderungenTableModel();
            this.tbForderungen.setModel(this.ftm);
        }
    }

    @Override
    public ForderungsStaffelung baueRueckgabewert() {
        this.pruefer.leseComponents(this.cbAngriffsKlaeger, this.cbVerteidigungsBeklagter, this.tbForderungen).parseEingabe();
        return this.pruefer.getRueckgabewert();
    }

    @Override
    public void setKostenrechner(Kostenrechner kostenrechner) {
        this.kostenrechner = kostenrechner;
    }

    public Kostenrechner getKostenrechner() {
        return this.kostenrechner;
    }
}

