/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.gebuehren;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrNeuAction;
import eu.gronos.kostenrechner.controller.gebuehren.StreitwertReduktionHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTenorAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageTerminAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageVerschiebenAction;
import eu.gronos.kostenrechner.controller.gebuehren.TeilklageruecknahmeParser;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class TeilklageruecknahmePanel
extends KostenJPanel
implements WerteLesbar<Teilklageruecknahme>,
GebuehrenTableTextfieldHandler {
    private static final long serialVersionUID = 1618328009895591401L;
    private static final TeilklageruecknahmePanel instance = new TeilklageruecknahmePanel();
    private Kostenrechner kostenrechner;
    JComboBox<Beteiligter> cbBeklagte;
    JComboBox<Beteiligter> cbKlaeger;
    private JFormattedTextField ftfStreitwertVorher;
    public JTable tabVorher;
    private GebuehrenTableModel gttmVorher;
    private final AbstractAction neueGebuehrVorherAction = new GebuehrNeuAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(12021), 0);
    private final AbstractAction neueGebuehrNachherAction = new GebuehrNeuAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(13021), 1);
    private final BooleanConfigAction berechnungsMethodeAction = new BooleanConfigAction((SchluesselBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(15001));
    private final AbstractAction tenorErmittelnAction = new TeilklageTenorAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(15005));
    private final AbstractAction gebuehrenTbVerschiebenAction = new TeilklageVerschiebenAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(17111));
    public AbstractAction klageruecknahmeTerminAction = new TeilklageTerminAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(17121));
    private JFormattedTextField ftfStreitwertNachher;
    private JFormattedTextField ftfObsiegen;
    private final FocusListener streitwertListener = new StreitwertReduktionHorcher(this);
    public JTable tabNachher;
    private GebuehrenTableModel gttmNachher;
    public static final String FEHLER_KEINE_GEBUEHREN = "Fehler: Keine Geb\u00fchren angefallen!";
    public static final String FEHLER_KEINE_GEBUEHREN_LANG = "Bitte geben Sie zun\u00e4chst ein welche Geb\u00fchren vor und/oder nach der Streitwertreduktion angefallen waren.";
    public static final int TABLE_FTF_VORHER = 0;
    public static final int TABLE_FTF_NACHHER = 1;
    public static final int FTF_OBSIEGEN = 2;
    private JToggleButton btnBerechnungsMethode;
    private JLabel lblStreitwertVorReduktion;
    private JLabel lblStreitwertNachReduktion;
    private JLabel lblLetztlichObsiegt;
    private ParsendUndBauend<Teilklageruecknahme> pruefer = new TeilklageruecknahmeParser();

    private TeilklageruecknahmePanel() {
    }

    public static TeilklageruecknahmePanel getInstance() {
        return instance;
    }

    @Override
    public void buildPanel() {
        JPanel pnParteien = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(11000), new GridBagLayout());
        Beteiligter[] klBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BeteiligtenTyp.KLAEGER, true);
        this.cbKlaeger = new JComboBox<Beteiligter>(klBezeichnerListe);
        this.beschrifter.beschrifteGemeinsam(new JLabel(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(11001), this.cbKlaeger, (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(11005), pnParteien);
        this.cbKlaeger.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
        Beteiligter[] bkBezeichnerListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(Beteiligter.BeteiligtenTyp.BEKLAGTE, true);
        this.cbBeklagte = new JComboBox<Beteiligter>(bkBezeichnerListe);
        this.beschrifter.beschrifteGemeinsam(new JLabel(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(11011), this.cbBeklagte, (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(11015), pnParteien);
        this.cbBeklagte.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
        JPanel pnVorher = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(12000), new GridBagLayout());
        this.lblStreitwertVorReduktion = new JLabel();
        this.ftfStreitwertVorher = (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(this.lblStreitwertVorReduktion, new JFormattedTextField(KostenJPanel.FORMATTER_INT), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(12005), pnVorher);
        this.ftfStreitwertVorher.setColumns(10);
        this.ftfStreitwertVorher.addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
        this.leereGebuehrenTabellen();
        this.tabVorher = (JTable)this.beschrifter.beschrifte(new JTable(this.getGttmVorher()), NameContainerSammlung.BESCHRIFTUNGEN.get(12011));
        this.entferneTastaturFalle(this.tabVorher);
        this.setzeGebuehrenTabelleAussehen(this.tabVorher);
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabVorher), NameContainerSammlung.BESCHRIFTUNGEN.get(12010), pnVorher);
        this.beschrifter.add((BeschriebeneAktion)this.neueGebuehrVorherAction, (Container)pnVorher);
        JPanel pnNachher = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(13000), new GridBagLayout());
        this.lblStreitwertNachReduktion = new JLabel();
        this.setFtfStreitwertNachher((JFormattedTextField)this.beschrifter.beschrifteGemeinsam(this.lblStreitwertNachReduktion, new JFormattedTextField(KostenJPanel.FORMATTER_INT), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(13005), pnNachher));
        this.getFtfStreitwertNachher().setColumns(10);
        this.getFtfStreitwertNachher().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
        this.getFtfStreitwertNachher().addFocusListener(this.streitwertListener);
        this.tabNachher = (JTable)this.beschrifter.beschrifte(new JTable(this.getGttmNachher()), NameContainerSammlung.BESCHRIFTUNGEN.get(13011));
        this.entferneTastaturFalle(this.tabNachher);
        this.setzeGebuehrenTabelleAussehen(this.tabNachher);
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabNachher), NameContainerSammlung.BESCHRIFTUNGEN.get(13010), pnNachher);
        this.beschrifter.add((BeschriebeneAktion)this.neueGebuehrNachherAction, (Container)pnNachher);
        JPanel pnLetztlichObsiegt = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(14000), new GridBagLayout());
        this.lblLetztlichObsiegt = new JLabel();
        this.setFtfObsiegen((JFormattedTextField)this.beschrifter.beschrifteGemeinsam(this.lblLetztlichObsiegt, new JFormattedTextField(KostenJPanel.FORMATTER_INT), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(14005), pnLetztlichObsiegt));
        this.getFtfObsiegen().addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
        this.leereTextfelder();
        this.btnBerechnungsMethode = (JToggleButton)this.beschrifter.add(this.berechnungsMethodeAction, (Container)this);
        this.beschrifter.add((BeschriebeneAktion)this.tenorErmittelnAction, (Container)this);
        PopupMenuBuilder builder = new PopupMenuBuilder();
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(17100), this.tabVorher, new Integer[]{1}, (BeschriebeneAktion)this.neueGebuehrVorherAction, (BeschriebeneAktion)this.klageruecknahmeTerminAction, (BeschriebeneAktion)this.eintragEntfernenAktion, (BeschriebeneAktion)this.gebuehrenTbVerschiebenAction);
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(17200), this.tabNachher, new Integer[]{1}, (BeschriebeneAktion)this.neueGebuehrNachherAction, (BeschriebeneAktion)this.klageruecknahmeTerminAction, (BeschriebeneAktion)this.eintragEntfernenAktion, (BeschriebeneAktion)this.gebuehrenTbVerschiebenAction);
        this.logDauer();
    }

    @Override
    public void leereWerte() {
        this.leereGebuehrenTabellen();
        this.leereTextfelder();
    }

    @Override
    public void setzeWerte(Teilklageruecknahme container) {
        this.cbKlaeger.setSelectedItem(container.parteien.get(0));
        this.cbBeklagte.setSelectedItem(container.parteien.get(1));
        this.ftfStreitwertVorher.setText(container.streitwerteUndObsiegen.get(0).toString());
        this.getFtfStreitwertNachher().setText(container.streitwerteUndObsiegen.get(1).toString());
        this.getFtfObsiegen().setText(container.streitwerteUndObsiegen.get(2).toString());
        this.setGttmVorher(new GebuehrenTableModel(container.vorher));
        this.tabVorher.setModel(this.getGttmVorher());
        this.setGttmNachher(new GebuehrenTableModel(container.nachher));
        this.tabNachher.setModel(this.getGttmNachher());
        Kostenrechner.getLogger().info("Fertig!");
    }

    @Override
    public Teilklageruecknahme baueRueckgabewert() {
        this.pruefer.leseComponents(this.cbKlaeger, this.cbBeklagte, this.tabVorher, this.tabNachher, this.getFormattedTextField(0), this.getFormattedTextField(1), this.getFormattedTextField(2)).parseEingabe();
        return this.pruefer.getRueckgabewert();
    }

    @Override
    public void setKostenrechner(Kostenrechner kostenrechner) {
        this.kostenrechner = kostenrechner;
    }

    @Override
    public boolean pruefeTabellen() {
        return this.getGttmVorher().getRowCount() > 0 || this.getGttmNachher().getRowCount() > 0;
    }

    @Override
    public JFormattedTextField getFormattedTextField(int index) {
        switch (index) {
            case 0: {
                return this.ftfStreitwertVorher;
            }
            case 1: {
                return this.ftfStreitwertNachher;
            }
            case 2: {
                return this.ftfObsiegen;
            }
        }
        return null;
    }

    @Override
    public String getLabelText(int index) {
        switch (index) {
            case 0: {
                return this.lblStreitwertVorReduktion.getText();
            }
            case 1: {
                return this.lblStreitwertNachReduktion.getText();
            }
            case 2: {
                return this.lblLetztlichObsiegt.getText();
            }
        }
        return null;
    }

    public void setFtfStreitwertNachher(JFormattedTextField ftfStreitwertNachher) {
        this.ftfStreitwertNachher = ftfStreitwertNachher;
    }

    public void setFtfObsiegen(JFormattedTextField ftfObsiegen) {
        this.ftfObsiegen = ftfObsiegen;
    }

    public Kostenrechner getKostenrechner() {
        return this.kostenrechner;
    }

    @Override
    public GebuehrenTableModel getTableModel(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return this.getGttmVorher();
        }
        if (index == 1) {
            return this.getGttmNachher();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getSelectedRow(int index) {
        if (index == 0) {
            if (this.tabVorher != null) {
                return this.tabVorher.getSelectedRow();
            }
            return -1;
        }
        if (index == 1) {
            if (this.tabNachher != null) {
                return this.tabNachher.getSelectedRow();
            }
            return -1;
        }
        throw new IndexOutOfBoundsException();
    }

    public GebuehrenTableModel getGttmVorher() {
        return this.gttmVorher;
    }

    public GebuehrenTableModel getGttmNachher() {
        return this.gttmNachher;
    }

    public boolean isQuotenMethodeVorziehen() {
        if (this.btnBerechnungsMethode == null) {
            return true;
        }
        return this.btnBerechnungsMethode.isSelected();
    }

    @Override
    public boolean requestFocusInWindow() {
        this.getKostenrechner().getTabbedPane().setSelectedIndex(0);
        return super.requestFocusInWindow();
    }

    private JFormattedTextField getFtfObsiegen() {
        return this.ftfObsiegen;
    }

    private JFormattedTextField getFtfStreitwertNachher() {
        return this.ftfStreitwertNachher;
    }

    private void leereTextfelder() {
        this.ftfStreitwertVorher.setText("0");
        this.getFtfStreitwertNachher().setText("0");
        this.getFtfObsiegen().setText("0");
    }

    private void leereGebuehrenTabellen() {
        this.setGttmVorher(new GebuehrenTableModel(new GebuehrenAuflistung()));
        this.setGttmNachher(new GebuehrenTableModel(new GebuehrenAuflistung()));
        if (this.tabVorher != null) {
            this.tabVorher.setModel(this.getGttmVorher());
        }
        if (this.tabNachher != null) {
            this.tabNachher.setModel(this.getGttmNachher());
        }
    }

    private void setGttmNachher(GebuehrenTableModel gttmNachher) {
        this.gttmNachher = gttmNachher;
    }

    private void setGttmVorher(GebuehrenTableModel gttmVorher) {
        this.gttmVorher = gttmVorher;
    }
}

