/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.helpanderror;

import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainer;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.beschriftungen.view.TabbedPaneFactory;
import eu.gronos.kostenrechner.controller.system.DatenschutzAblehnungAktion;
import eu.gronos.kostenrechner.controller.system.DatenschutzZustimmungAktion;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.view.helpanderror.AkzeptanzDialog;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DatenschutzZustimmungDialog
extends AkzeptanzDialog<DatenschutzZustimmung> {
    private static final String RESOURCES_DSGVO_BASIS = "resources/dsgvo-basis.html";
    private static final String RESOURCES_DSGVO_ANHANG = "resources/dsgvo-anhang.html";
    private static final long serialVersionUID = 5974122103013004015L;
    private String htmlfile;
    private JTabbedPane tabbedPane;
    private DatenschutzZustimmungAktion pruefer;
    private JLabel lblFrage;

    public DatenschutzZustimmungDialog(Window owner, int level, DatenschutzZustimmung zustimmung) throws HeadlessException {
        this(owner, true, level, zustimmung);
    }

    public DatenschutzZustimmungDialog(Window owner, boolean zustimmungNoetig, int level, DatenschutzZustimmung zustimmung) throws HeadlessException {
        super(owner, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74000));
        this.pruefer = new DatenschutzZustimmungAktion(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74051), level, zustimmung);
        this.baueTabbedPane(level);
        super.setOkButtonToBeFocussed(true);
        if (zustimmungNoetig) {
            super.getOkButton().setAction(this.pruefer);
        }
    }

    public void wechseleTab() {
        this.tabbedPane.setComponentAt(0, new JPanel());
        this.tabbedPane.setComponentAt(1, this.contentPanel);
        this.setHtmlFile(34);
        this.activateTabs(1);
        super.setHtml(this.htmlfile);
        this.tabbedPane.setSelectedIndex(1);
        this.beschrifter.beschrifte(this.lblFrage, (NameContainer)((Object)this.beschrifter.changeTo((VorsorgendeBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74220), this.pruefer.calculateIndex())));
        JButton no = new DatenschutzAblehnungAktion((LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74052), this, this.pruefer).toButton();
        this.getButtonPane().add(no, 1, 1);
    }

    @Override
    protected DatenschutzZustimmung baueRueckgabewert() {
        return this.pruefer.getRueckgabewert();
    }

    @Override
    protected void setContentPanel() {
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.contentPanel.setBorder(BORDER);
        this.contentPanel.setLayout(gbl_contentPanel);
    }

    @Override
    protected void fuelleContentPane() {
        this.baueTextPane(this.htmlfile);
        this.lblFrage = (JLabel)this.beschrifter.beschrifteVergittert(new JLabel(), (NameContainer)((Object)this.beschrifter.changeTo((Vorsorgend)((Object)NameContainerSammlung.BESCHRIFTUNGEN.get(74220)), this.pruefer.calculateIndex())), this.contentPanel);
    }

    private void baueTabbedPane(int level) {
        int activeTab;
        if (34 == level && this.pruefer.getRueckgabewert().emailBasisZugestimmt) {
            activeTab = 1;
            TabbedPaneFactory.intoTabbedPane(this.tabbedPane, new JPanel(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74100));
            TabbedPaneFactory.intoTabbedPane(this.tabbedPane, this.contentPanel, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74200));
            this.setHtmlFile(34);
        } else {
            activeTab = 0;
            TabbedPaneFactory.intoTabbedPane(this.tabbedPane, this.contentPanel, (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74100));
            TabbedPaneFactory.intoTabbedPane(this.tabbedPane, new JPanel(), (Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(74200));
            this.setHtmlFile(21);
        }
        this.activateTabs(activeTab);
        this.tabbedPane.setSelectedIndex(activeTab);
    }

    private void setHtmlFile(int level) {
        this.htmlfile = 34 == level ? RESOURCES_DSGVO_ANHANG : RESOURCES_DSGVO_BASIS;
    }

    private void activateTabs(int activeTab) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (activeTab == i) {
                this.tabbedPane.setEnabledAt(i, true);
            } else {
                this.tabbedPane.setEnabledAt(i, false);
            }
            ++i;
        }
    }
}

