/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.result;

import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import javax.swing.table.DefaultTableCellRenderer;

public class BegruendungsZahlenRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -6700491875528099319L;
    private final boolean alsBruch;
    private String format;

    public BegruendungsZahlenRenderer(boolean alsBruch) {
        this(alsBruch, "%,.2f");
    }

    public BegruendungsZahlenRenderer(boolean alsBruch, String format) {
        this.alsBruch = alsBruch;
        this.format = format;
    }

    @Override
    protected void setValue(Object value) {
        if (value instanceof Euro) {
            this.setText(((HtmlRtfFormattierend)value).toHtmlString());
        } else if (value instanceof Fraction) {
            Fraction f = (Fraction)value;
            this.setText(this.alsBruch ? f.toHtmlString() : f.toPercentString());
        } else if (value instanceof Number) {
            this.setText(String.format(this.format, ((Number)value).doubleValue()));
        } else {
            super.setValue(value);
        }
        this.setHorizontalAlignment(4);
    }
}

