/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.result;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.controller.BooleanConfigAction;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.SchluesselBeschriftung;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.beschriftungen.view.FontHelferForWindow;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.TenorBegruendungAction;
import eu.gronos.kostenrechner.controller.files.RtfWerkzeugKasten;
import eu.gronos.kostenrechner.controller.files.RtfZwischenablageAction;
import eu.gronos.kostenrechner.controller.files.SpeichereRtfAction;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.controller.system.SchreibeEmailTenorFalsch;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.util.TenorierendAdapter;
import java.awt.Window;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class TenorDialog
extends BeschrifteterJDialog {
    private static final long serialVersionUID = -7570808761464484864L;
    JTextPane textPane;
    Tenorierend tenorierend;
    final VerfahrensDatenContainer container;
    private final FontHelferForWindow helper = new FontHelferForWindow(this);
    private final BeschriebeneAktion tenorInZwischenablage = new RtfZwischenablageAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71011));
    private final BeschriebeneAktion tenorSpeichern;
    private final AbstractAction begruendungEinfuegen = new TenorBegruendungAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71041));
    private BooleanConfigAction liXml = new BooleanConfigAction((SchluesselBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71051));
    private final BeschriebeneAktion emailSchreibenTenorFalsch;
    private boolean bereitsGruendeDa = false;
    private final RtfWerkzeugKasten kit;

    public TenorDialog(JFrame owner, TenorDatenContainer container) {
        super((Window)owner, ((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71000)).setTitle(container.berechnungsTyp));
        this.tenorierend = new TenorierendAdapter(container);
        this.container = container;
        this.kit = new RtfWerkzeugKasten(container.allgemein.alsBruch);
        this.emailSchreibenTenorFalsch = new SchreibeEmailTenorFalsch((LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71031), container);
        this.tenorSpeichern = new SpeichereRtfAction(this, container, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71021));
    }

    public void setBegruendungText() {
        if (!this.bereitsGruendeDa) {
            String gruende = this.tenorierend.getGruende();
            try {
                int caret = this.textPane.getCaretPosition();
                String gruendeUeberschrift = "Entscheidungsgr\u00fcnde\n";
                if (this.container.allgemein.selectedPanel == 3) {
                    gruendeUeberschrift = "Im Einzelnen\n";
                }
                this.kit.insertString(gruende, this.tenorierend, this.textPane.getPreferredSize(), gruendeUeberschrift);
                Kostenrechner.getLogger().info(String.format("caret: %04d; ", caret));
                this.textPane.setCaretPosition(caret);
                this.caretVisible(this.textPane);
                this.bereitsGruendeDa = true;
                this.begruendungEinfuegen.setEnabled(false);
            }
            catch (BadLocationException ble) {
                FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
            }
        }
    }

    public RtfWerkzeugKasten getKit() {
        return this.kit;
    }

    public boolean isXmlSelected() {
        if (this.liXml != null) {
            return this.liXml.getValue();
        }
        return false;
    }

    @Override
    protected void fuelleContentPane() {
        this.textPane = (JTextPane)this.beschrifter.beschrifte(new JTextPane(), NameContainerSammlung.BESCHRIFTUNGEN.get(71111));
        this.textPane.setEditorKit(this.getKit());
        this.caretVisible(this.textPane);
        this.toContentPanel(new JScrollPane(this.textPane), NameContainerSammlung.BESCHRIFTUNGEN.get(71110));
        this.toButtonPanel(this.tenorInZwischenablage);
        this.toButtonPanel(this.tenorSpeichern);
        this.toButtonPanel(this.emailSchreibenTenorFalsch);
        DefaultStyledDocument doc = this.setKostentenorText();
        this.helper.setPreferredSizeFromAttributeSet(doc.getStyle("base"), 150, 40);
        this.setDefaultCloseOperation(2);
        new PopupMenuBuilder().build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(71050), this.textPane, new Integer[]{1}, this.tenorSpeichern, this.liXml, this.tenorInZwischenablage, (BeschriebeneAktion)this.begruendungEinfuegen);
        this.begruendungEinfuegen.setEnabled(true);
        if (this.container.allgemein.selectedPanel == 3) {
            SwingUtilities.invokeLater(() -> this.setBegruendungText());
        }
    }

    private DefaultStyledDocument setKostentenorText() {
        final String tenor = this.tenorierend.erzeugeTenor();
        DefaultStyledDocument doc = this.kit.getDefaultStyledDocument();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TenorDialog.this.kit.insertString(tenor, TenorDialog.this.tenorierend.getTenorBeschreibung(), TenorDialog.this.tenorierend.getGruende() == null || TenorDialog.this.tenorierend.getGruende().isEmpty());
                    TenorDialog.this.caretVisible(TenorDialog.this.textPane);
                }
                catch (BadLocationException ble) {
                    FehlerHelper.zeigeFehler(ble.getLocalizedMessage(), ble);
                }
            }
        });
        return doc;
    }
}

