/*
 * DialogFensterSchliessenHorcher.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.beschriftungen.controller;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import eu.gronos.beschriftungen.view.BeschrifteterJDialog;

/**
 * Der Horcher soll dafür sorgen, dass sich das Fenster über die
 * Schließen-Schaltfläche ("X" bzw. roter Button) verhält wie bei Abbruch
 *
 * @author Peter Schuster (setrok)
 * @date 3 May 2019
 *
 */
public class DialogFensterSchliessenHorcher extends WindowAdapter {
	private final BeschrifteterJDialog dialog;

	public DialogFensterSchliessenHorcher(BeschrifteterJDialog hinzufuegenDialog) {
		this.dialog = hinzufuegenDialog;
	}

	@Override
	public void windowClosing(WindowEvent e) {
		this.dialog.fensterSchliessenBeiAbbruch();
	}
}