package eu.gronos.beschriftungen.model;

import java.awt.GridBagConstraints;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * 
 */
public class AnchorAdapter extends XmlAdapter<String, Integer> {

	private static final Map<String, Integer> map = new HashMap<>();
	static {
		map.put("CENTER", GridBagConstraints.CENTER);
		map.put("NORTH", GridBagConstraints.NORTH);
		map.put("NORTHEAST", GridBagConstraints.NORTHEAST);
		map.put("EAST", GridBagConstraints.EAST);
		map.put("SOUTHEAST", GridBagConstraints.SOUTHEAST);
		map.put("SOUTH", GridBagConstraints.SOUTH);
		map.put("SOUTHWEST", GridBagConstraints.SOUTHWEST);
		map.put("WEST", GridBagConstraints.WEST);
		map.put("NORTHWEST", GridBagConstraints.NORTHWEST);
		map.put("PAGE_START", GridBagConstraints.PAGE_START);
		map.put("PAGE_END", GridBagConstraints.PAGE_END);
		map.put("LINE_START", GridBagConstraints.LINE_START);
		map.put("LINE_END", GridBagConstraints.LINE_END);
		map.put("FIRST_LINE_START", GridBagConstraints.FIRST_LINE_START);
		map.put("FIRST_LINE_END", GridBagConstraints.FIRST_LINE_END);
		map.put("LAST_LINE_START", GridBagConstraints.LAST_LINE_START);
		map.put("LAST_LINE_END", GridBagConstraints.LAST_LINE_END);
		map.put("BASELINE", GridBagConstraints.BASELINE);
		map.put("BASELINE_LEADING", GridBagConstraints.BASELINE_LEADING);
		map.put("BASELINE_TRAILING", GridBagConstraints.BASELINE_TRAILING);
		map.put("ABOVE_BASELINE", GridBagConstraints.ABOVE_BASELINE);
		map.put("ABOVE_BASELINE_LEADING", GridBagConstraints.ABOVE_BASELINE_LEADING);
		map.put("ABOVE_BASELINE_TRAILING", GridBagConstraints.ABOVE_BASELINE_TRAILING);
		map.put("BELOW_BASELINE", GridBagConstraints.BELOW_BASELINE);
		map.put("BELOW_BASELINE_LEADING", GridBagConstraints.BELOW_BASELINE_LEADING);
		map.put("BELOW_BASELINE_TRAILING", GridBagConstraints.BELOW_BASELINE_TRAILING);
	}

	@Override
	public Integer unmarshal(String v) {
		return map.getOrDefault(v, GridBagConstraints.CENTER);
	}

	@Override
	public String marshal(Integer v) {
		return map.entrySet().stream().filter(e -> e.getValue().equals(v)).map(Map.Entry::getKey).findFirst()
				.orElse("CENTER");
	}

}
