/*
 * BildOhneTitel.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.net.URL;

import javax.xml.bind.annotation.XmlAttribute;

import eu.gronos.beschriftungen.interfaces.Bebildert;

/**
 * eine {@link UnBeschriftung}, die {@link Bebildert} implementiert und eine
 * Referenz auf ein ImageIcon speichert.
 *
 * @author Peter Schuster (setrok)
 * @date 02.02.2020
 *
 */
public class BildOhneTitel extends UnBeschriftung implements Bebildert {
	private static final long serialVersionUID = 3996703151744826521L;
	private String image;

	/**
	 * The key used for storing an <code>Icon</code>. This is typically used by
	 * buttons, such as <code>JButton</code> and <code>JToggleButton</code>.
	 * 
	 * @return gibt {@link #image} als {@link String} zurück, denn {@link URL} geht
	 *         nicht.
	 *
	 * @see eu.gronos.beschriftungen.interfaces.Bebildert#getImage()
	 */
	@Override
	@XmlAttribute(name = "img")
	public String getImage() {
		return image;
	}

	/**
	 * @param img d. {@link #image}, d. gesetzt werden soll als {@link URL}.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Bebildert#setImage(java.lang.String)
	 */
	@Override
	public void setImage(String img) {
		this.image = img;
	}

}