/*
 * BooleanConfigOptionParameter.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import javax.xml.bind.annotation.XmlAttribute;

import eu.gronos.beschriftungen.util.BooleanConfigOption;

/**
 * Von {@link ConfigSchluessel} abgeleitetes Parameter-Objekt für
 * {@link BooleanConfigOption}
 * 
 * @author Peter Schuster (setrok)
 * @date 31.01.2020
 */
public class BooleanConfigSchluessel extends ConfigSchluessel<Boolean> {

	/**
	 * @param schluessel   der Schlüssel im Unterast
	 *                     <code>"/eu/gronos/kostentenor"</code> (String)
	 * @param standardWert der Standard-Wert als {@link Boolean}, falls der
	 *                     Schlüssel noch nicht angelegt ist
	 * 
	 */
	public BooleanConfigSchluessel(String schluessel, Boolean standardWert) {
		super(schluessel, standardWert);
	}

	public BooleanConfigSchluessel() {
		super();
	}

	/**
	 * @return gibt {@link #standardWert} als {@link boolean} zurück, das ist der
	 *         Standard-Wert als {@link boolean}, falls der Schlüssel noch nicht
	 *         angelegt ist.
	 */
	@Override
	@XmlAttribute(name = "standard")
	public Boolean getStandardWert() {
		return standardWert;
	}

	/**
	 * @param standardWert d. {@link #standardWert}, d. gesetzt werden soll als
	 *                     {@link boolean}.
	 */
	@Override
	public void setStandardWert(Boolean standardWert) {
		this.standardWert = standardWert;
	}
}