package eu.gronos.beschriftungen.model;

import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * The {@link GridBagConstraints} class specifies constraints for components
 * that are laid out using the GridBagLayout class. Creates a GridBagConstraint
 * object with all of its fields set to their default value.
 * 
 */
public class GitterBeutelBeschraenkungen {

	/**
	 * specifies the cell containing the leading edge of the component's display
	 * area, where the first cell in a row has gridx=0. The leading edge of a
	 * component's display area is its left edge for a horizontal, left-to-right
	 * container and its right edge for a horizontal, right-to-left container. The
	 * value RELATIVE specifies that the component be placed immediately following
	 * the component that was added to the container just before this component was
	 * added.
	 * 
	 */
	@XmlAttribute
	public int gridx;

	/**
	 * specifies the cell at the top of the component's display area, where the
	 * topmost cell has gridy=0. The value RELATIVE specifies that the component be
	 * placed just below the component that was added to the container just before
	 * this component was added.
	 */
	@XmlAttribute
	public int gridy;

	/**
	 * Specifies the number of cells in a row for the component's display area. Use
	 * REMAINDER to specify that the component's display area will be from gridx to
	 * the last cell in the row. Use RELATIVE to specify that the component's
	 * display area will be from gridx to the next to the last one in its row.
	 * gridwidth should be non-negative and the default value is 1.
	 */
	@XmlAttribute
	public int gridwidth;

	/**
	 * Specifies the number of cells in a column for the component's display area.
	 * Use REMAINDER to specify that the component's display area will be from gridy
	 * to the last cell in the column. Use RELATIVE to specify that the component's
	 * display area will be from gridy to the next to the last one in its column.
	 * gridheight should be a non-negative value and the default value is 1.
	 */
	@XmlAttribute
	public int gridheight;

	/**
	 * 
	 */
	@XmlAttribute
	public double weightx;

	/**
	 * 
	 */
	@XmlAttribute
	public double weighty;

	@XmlAttribute
	public int insetsTop;

	@XmlAttribute
	public int insetsLeft;

	@XmlAttribute
	public int insetsBottom;

	@XmlAttribute
	public int insetsRight;

	/**
	 * 
	 */
	@XmlAttribute
	@XmlJavaTypeAdapter(AnchorAdapter.class)
	public Integer anchor;

	/**
	 * This field is used when the component's display area is larger than the
	 * component's requested size. It determines whether to resize the component,
	 * and if so, how.
	 * 
	 * The following values are valid for fill:
	 * 
	 * NONE: Do not resize the component. HORIZONTAL: Make the component wide enough
	 * to fill its display area horizontally, but do not change its height.
	 * VERTICAL: Make the component tall enough to fill its display area vertically,
	 * but do not change its width. BOTH: Make the component fill its display area
	 * entirely. The default value is NONE.
	 */
	@XmlAttribute
	@XmlJavaTypeAdapter(FillAdapter.class)
	public Integer fill;

	/**
	 * 
	 * This field specifies the internal padding, that is, how much space to add to
	 * the minimum height of the component. The height of the component is at least
	 * its minimum height plus ipady pixels.
	 * 
	 * The default value is 0.
	 * 
	 * @see java.awt.GridBagConstraints.ipady
	 * 
	 */
	@XmlAttribute
	public int ipady;

	/**
	 * This field specifies the internal padding of the component, how much space to
	 * add to the minimum width of the component. The width of the component is at
	 * least its minimum width plus ipadx pixels.
	 * 
	 * The default value is 0.
	 * 
	 * @see java.awt.GridBagConstraints.ipadx
	 * 
	 */
	@XmlAttribute
	public int ipadx;

	@XmlAttribute
	@XmlIDREF
	public Beschriftung ref;

	public GridBagConstraints toGitterBeutel() {
		return new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill,
				new Insets(insetsTop, insetsLeft, insetsBottom, insetsRight), ipadx, ipady);
	}
}
