/*
 * IntegerConfigSchluessel.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import javax.xml.bind.annotation.XmlAttribute;

import eu.gronos.beschriftungen.util.IntegerConfigOption;

/**
 * Von {@link ConfigSchluessel} abgeleitetes Parameter-Objekt für
 * {@link IntegerConfigOption}
 *
 * @author Peter Schuster (setrok)
 * @date 16.03.2020
 *
 */
public class IntegerConfigSchluessel extends ConfigSchluessel<Integer> {

	/**
	 * @param schluessel   der Schlüssel im Unterast
	 *                     <code>"/eu/gronos/kostentenor"</code> (String)
	 * @param standardWert der Standard-Wert, falls der Schlüssel noch nicht
	 *                     angelegt ist.
	 */
	public IntegerConfigSchluessel(String schluessel, Integer standardWert) {
		super(schluessel, standardWert);
	}

	public IntegerConfigSchluessel() {
		super();
	}

	/**
	 * @return gibt {@link #standardWert} als {@link String} zurück, das ist der
	 *         Standard-Wert als {@link String}, falls der Schlüssel noch nicht
	 *         angelegt ist.
	 * 
	 * @see eu.gronos.beschriftungen.model.ConfigSchluessel#getStandardWert()
	 */
	@Override
	@XmlAttribute(name = "standard")
	public Integer getStandardWert() {
		return standardWert;
	}

	/**
	 * 
	 * @param standardWert d. {@link #standardWert}, d. gesetzt werden soll als
	 *                     {@link Integer}.
	 * 
	 * @see eu.gronos.beschriftungen.model.ConfigSchluessel#setStandardWert(java.lang.Object)
	 */
	@Override
	public void setStandardWert(Integer standardWert) {
		this.standardWert = standardWert;
	}
}
