/*
 * NameContainerMapAdapter.java
 * eu.gronos.kostenrechnertest.guitest (Kostenrechner Test)
 */
package eu.gronos.beschriftungen.model;

import java.util.Map;
import java.util.Set;

import javax.xml.bind.JAXB;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * Ein {@link XmlAdapter} hilft, die {@link NameContainerMap} mit {@link JAXB}
 * in XML zu verwandeln und sie auch wieder einzulesen.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2019
 *
 */
public class NameContainerMapAdapter extends XmlAdapter<NameContainerMapWrapper, NameContainerMap> {

	/**
	 * Die Methode wandelt für den {@link JAXB}-Export mit einem {@link Marshaller}
	 * eine {@link NameContainerMap} in einen {@link NameContainerMapWrapper}, vor
	 * allem in das darin enthaltene {@link Set} aus {@link NameContainer}n.
	 * 
	 * @param map die {@link NameContainerMap} als {@link Map} aus
	 *            {@link NameContainer}n.
	 * @return einen {@link NameContainerMapWrapper} mit {@link Set} aus
	 *         {@link NameContainer}n.
	 * @throws Exception wenn es einen Fehler beim Konvertieren gibt.
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
	 */
	@Override
	public NameContainerMapWrapper marshal(NameContainerMap map) throws Exception {
		NameContainerMapWrapper wrap = new NameContainerMapWrapper();
		for (Integer key : map.keySet())
			wrap.getBeSchreibSet().add(map.get(key));
		return wrap;
	}

	/**
	 * Die Methode wandelt für den {@link JAXB}-Import mit
	 * {@link JAXB#unmarshal(java.io.InputStream, Class)} o.ä. das
	 * {@link NameContainerMapWrapper#getBeSchreibSet()} in eine
	 * {@link NameContainerMap}
	 * 
	 * @param wrap ein {@link NameContainerMapWraper}
	 * @return eine {@link NameContainerMap} mit Werten.
	 * 
	 * @throws Exception wenn es beim Konvertieren einen Fehler gibt.
	 * 
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
	 */
	@Override
	public NameContainerMap unmarshal(NameContainerMapWrapper wrap) throws Exception {
		NameContainerMap map = new NameContainerMap();
		for (NameContainer nc : wrap.getBeSchreibSet()) {
			map.put(nc.getKey(), nc);
		}
		return map;
	}

}
