/*
 * UnBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlIDREF;

/**
 * andere von der abstrakten Klasse NameContainer abgeleitete Klasse
 * „UnBeschriftung“ mit Verweis beschriebenVon (vom Typ Beschriftung, XmlIdRef),
 * bekommt davon die shortDescription, braucht wahrscheinlich ChangeListener
 * oder PropertyListener für wenn sich die Beschriftung ändert,
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class UnBeschriftung extends NameContainer {
	private static final long serialVersionUID = 364331004113307135L;
	private Beschriftung ref;
	private String prefix = null;
	private String suffix = null;

	/**
	 * @return gibt {@link #ref} als {@link Beschriftung} zurück.
	 */
	@XmlAttribute(name = "ref")
	@XmlIDREF
	public Beschriftung getRef() {
		return ref;
	}

	/**
	 * @param ref d. {@link #ref}, d. gesetzt werden soll als {@link Beschriftung}.
	 */
	public void setRef(Beschriftung ref) {
		this.ref = ref;
	}

	/**
	 * @return gibt {@link #prefix} als {@link String} zurück, also einen vor
	 *         {@link Beschriftung#getTitle()} einzufügenden Text.
	 */
	@XmlAttribute(name = "prefix")
	public String getPrefix() {
		return prefix;
	}

	/**
	 * @param prefix d. {@link #prefix}, d. gesetzt werden soll als {@link String}.
	 */
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/**
	 * @return gibt {@link #suffix} als {@link String} zurück, also einen an
	 *         {@link Beschriftung#getTitle()} anzuhängenden Text.
	 */
	@XmlAttribute(name = "suffix")
	public String getSuffix() {
		return suffix;
	}

	/**
	 * @param suffix d. {@link #suffix}, d. gesetzt werden soll als {@link String}.
	 */
	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}
}