/**
 * AllzweckHorcher.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/**
 * Ein Adapter mit leeren Methoden für alle möglichen Listener-Interfaces:
 * MouseListener, ActionListener, WindowListener, FocusListener, ChangeListener,
 * ItemListener, KeyListener
 * 
 * @author Peter Felix Schuster (setrok)
 * @date 04.08.2014
 */
public class AllzweckHorcher implements MouseListener, MouseMotionListener,
		ActionListener, WindowListener, FocusListener, ChangeListener,
		ItemListener, KeyListener, ListSelectionListener, TableModelListener {

	/**
	 * Konstruktor:
	 * 
	 */
	public AllzweckHorcher() {
		// do nothing
	}

	/**
	 * Invoked when a key has been pressed. See the class description for
	 * KeyEvent for a definition of a key pressed event.
	 * 
	 * @param ke
	 * 
	 * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
	 */
	@Override
	public void keyPressed(KeyEvent ke) {
		// do nothing
	}

	/**
	 * Invoked when a key has been released. See the class description for
	 * KeyEvent for a definition of a key released event.
	 * 
	 * @param ke
	 * 
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 */
	@Override
	public void keyReleased(KeyEvent ke) {
		// do nothing
	}

	/**
	 * Invoked when a key has been typed. See the class description for KeyEvent
	 * for a definition of a key typed event.
	 * 
	 * @param ke
	 * 
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	@Override
	public void keyTyped(KeyEvent ke) {
		// do nothing
	}

	/**
	 * Invoked when an item has been selected or deselected by the user. The
	 * code written for this method performs the operations that need to occur
	 * when an item is selected (or deselected).
	 * 
	 * @param ie
	 * 
	 * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
	 */
	@Override
	public void itemStateChanged(ItemEvent ie) {
		// do nothing
	}

	/**
	 * Invoked when the target of the listener has changed its state.
	 * 
	 * @param ce
	 * 
	 * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
	 */
	@Override
	public void stateChanged(ChangeEvent ce) {
		// do nothing
	}

	/**
	 * Invoked when a component gains the keyboard focus.
	 * 
	 * @param fe
	 * 
	 * @see java.awt.event.FocusListener#focusGained(java.awt.event.FocusEvent)
	 */
	@Override
	public void focusGained(FocusEvent fe) {
		// do nothing
	}

	/**
	 * Invoked when a component loses the keyboard focus.
	 * 
	 * @param fe
	 * 
	 * @see java.awt.event.FocusListener#focusLost(java.awt.event.FocusEvent)
	 */
	@Override
	public void focusLost(FocusEvent fe) {
		// do nothing
	}

	/**
	 * Invoked when the Window is set to be the active Window. Only a Frame or a
	 * Dialog can be the active Window. The native windowing system may denote
	 * the active Window or its children with special decorations, such as a
	 * highlighted title bar. The active Window is always either the focused
	 * Window, or the first Frame or Dialog that is an owner of the focused
	 * Window.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowActivated(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowActivated(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when a window has been closed as the result of calling dispose on
	 * the window.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowClosed(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowClosed(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when the user attempts to close the window from the window's
	 * system menu.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowClosing(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when a Window is no longer the active Window. Only a Frame or a
	 * Dialog can be the active Window. The native windowing system may denote
	 * the active Window or its children with special decorations, such as a
	 * highlighted title bar. The active Window is always either the focused
	 * Window, or the first Frame or Dialog that is an owner of the focused
	 * Window.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowDeactivated(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowDeactivated(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when a window is changed from a minimized to a normal state.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowDeiconified(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowDeiconified(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when a window is changed from a normal to a minimized state. For
	 * many platforms, a minimized window is displayed as the icon specified in
	 * the window's iconImage property.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowIconified(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowIconified(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked the first time a window is made visible.
	 * 
	 * @param we
	 * 
	 * @see java.awt.event.WindowListener#windowOpened(java.awt.event.WindowEvent)
	 */
	@Override
	public void windowOpened(WindowEvent we) {
		// do nothing
	}

	/**
	 * Invoked when an action occurs.
	 * 
	 * @param ae
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent ae) {
		// do nothing
	}

	/**
	 * Invoked when the mouse button has been clicked (pressed and released) on
	 * a component.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseClicked(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when the mouse enters a component.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseEntered(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when the mouse exits a component.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseExited(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	@Override
	public void mousePressed(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseReleased(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when a mouse button is pressed on a component and then dragged.
	 * MOUSE_DRAGGED events will continue to be delivered to the component where
	 * the drag originated until the mouse button is released (regardless of
	 * whether the mouse position is within the bounds of the component). Due to
	 * platform-dependent Drag&Drop implementations, MOUSE_DRAGGED events may
	 * not be delivered during a native Drag&Drop operation.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseDragged(MouseEvent me) {
		// do nothing
	}

	/**
	 * Invoked when the mouse cursor has been moved onto a component but no
	 * buttons have been pushed.
	 * 
	 * @param me
	 * 
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseMoved(MouseEvent me) {
		// do nothing
	}

	/**
	 * Called whenever the value of the selection changes.
	 * 
	 * @param lse
	 *            ein {@link javax.swing.event.ListSelectionEvent
	 *            ListSelectionEvent}
	 * 
	 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
	 */
	@Override
	public void valueChanged(ListSelectionEvent lse) {
		// do nothing
	}

	/**
	 * TableModelListener defines the interface for an object that listens to
	 * changes in a TableModel. This fine grain notification tells listeners the
	 * exact range of cells, rows, or columns that changed.
	 * 
	 * @param tme
	 *            ein {@link javax.swing.event.TableModelEvent TableModelEvent}
	 * 
	 * @see javax.swing.event.TableModelListener#tableChanged(javax.swing.event.TableModelEvent)
	 */
	@Override
	public void tableChanged(TableModelEvent tme) {
		// do nothing
	}

}
