/**
 * TenorBegruendungAction.java
 * eu.gronos.kostenrechner.view.result (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.view.result.TenorDialog;

/**
 * Die Action ruft {@link TenorDialog#setBegruendungText()} auf.
 * 
 * @author Peter Schuster (setrok)
 * @date 22 Nov 2018
 *
 */
public class TenorBegruendungAction extends BeschriebeneAktion {
	private final TenorDialog dialog;
	private static final long serialVersionUID = 6000735647165897065L;

	/**
	 * Konstruktor.
	 * 
	 * @param name             {@link Action#NAME}
	 * @param shortDescription {@link Action#SHORT_DESCRIPTION}
	 * @param dialog           {@link TenorDialog}
	 */
	public TenorBegruendungAction(TenorDialog dialog, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.dialog = dialog;
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		this.dialog.setBegruendungText();
	}
}