/*
 * BeteiligtenPruefer.java
 * eu.gronos.kostenrechner.controller.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.util.baumbach.BeteiligtenPruefer;

/**
 * Der {@link ParsendUndBauend} kontrolliert alle Werte zum Bau eines {@link Beteiligter}n
 *
 * @author Peter Schuster (setrok)
 * @date 16.07.2019
 *
 */
public class BeteiligtenParser implements ParsendUndBauend<BaumbachBeteiligter> {

	private BaumbachBeteiligter rueckgabewert;
	private JComboBox<Beteiligter> cmbTypGenusNumerus;
	private JCheckBox cbAnWiderklageBeteiligt;
	private JFormattedTextField ftfUnterliegen;
	private JFormattedTextField ftfStreitwert;

	/**
	 */
	public BeteiligtenParser() {
		super();
	}

	/**
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#leseComponents(Component[])
	 */
	@SuppressWarnings("unchecked")
	@Override
	public ParsendUndBauend<BaumbachBeteiligter> leseComponents(Component... components) {
		if (components != null) {
			for (Component comp : components) {
				JComponent component = (JComponent) comp;
				if ("35005".equals(component.getName())) {// cmbTypGenusNumerus
					cmbTypGenusNumerus = (JComboBox<Beteiligter>) component;
				} else if ("35011".equals(component.getName())) {// cbAnWiderklageBeteiligt
					cbAnWiderklageBeteiligt = (JCheckBox) component;
				} else if ("35035".equals(component.getName())) {// ftfUnterliegen
					ftfUnterliegen = (JFormattedTextField) component;
				} else if ("35025".equals(component.getName())) {// ftfStreitwert
					ftfStreitwert = (JFormattedTextField) component;
				} else {
					System.out.println("Komisch: " + component.getName());
				}
			}
		}
		return this;
	}

	/**
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		try {
			rueckgabewert = leseFelder();
			return parseEingabe(rueckgabewert);
		} catch (IllegalArgumentException | NullPointerException ne) {
			FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
			return false;
		}
	}

	/**
	 * Methode zum Plausis checken, wird vom OK-Button aufgerufen.
	 * 
	 * @return true, wenn alle Plausis eingehalten werden
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#parseEingabe(java.lang.Object)
	 */
	@Override
	public boolean parseEingabe(BaumbachBeteiligter beteiligter) throws IllegalArgumentException, NullPointerException {
		this.rueckgabewert = beteiligter;
		return new BeteiligtenPruefer().pruefeEingabe(rueckgabewert);
	}

	/**
	 * Die Methode gibt einen Rückgabewert zurück, der aus den Eingabefeldern des
	 * Dialogs zusammengebaut wurde, der dann von {@link #showDialogAndAsk()} an die
	 * aufrufende Maske zurückgegeben werden kann.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#getRueckgabewert()
	 */
	@Override
	public BaumbachBeteiligter getRueckgabewert() {
		return rueckgabewert;
	}

	private BaumbachBeteiligter leseFelder() throws IllegalArgumentException, NullPointerException {
		/*
		 * Ob überhaupt Widerkläger/beklagte angezeigt werden, erkennt der Prüfer an
		 * cbAnWiderBeteiligt#isVisible
		 */
		final boolean anWiderklageBeteiligt = (cbAnWiderklageBeteiligt.isVisible()
				&& cbAnWiderklageBeteiligt.isSelected());
		final double unterliegen = new NumberExtractor(ftfUnterliegen,
				ftfUnterliegen.getAccessibleContext().getAccessibleName()).extractDouble();
		final double streitwert = new NumberExtractor(ftfStreitwert,
				ftfStreitwert.getAccessibleContext().getAccessibleName()).extractDouble();
		rueckgabewert = new BaumbachBeteiligter(getSelectedItem(), Euro.ofEuros(streitwert), Euro.ofEuros(unterliegen), anWiderklageBeteiligt);
		return rueckgabewert;
	}

	private Beteiligter getSelectedItem() {
		return cmbTypGenusNumerus.getModel().getElementAt(cmbTypGenusNumerus.getSelectedIndex());
	}


}
