/**
 * StreitgenossenAssistentAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.view.baumbach.BaumbachAssistentDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.result.TenorDialog;

/**
 * {@link BeschriebeneAktion}, die den {@link BaumbachAssistentDialog} aufruft!
 * {@link KeyEvent#VK_A}
 * 
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenAssistentAction extends BeschriebeneAktion
		implements AbfrageLieferant<BaumbachAssistentDialog> {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = 3372100502718641247L;
	private BaumbachAssistentDialog dialog = null;

	/**
	 * Konstruktor:
	 * 
	 * @param panel        {@link StreitgenossenPanel}
	 * @param beschriftung eine {@link LangBeschriftung} mit
	 *                     {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenAssistentAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		setDialog(new BaumbachAssistentDialog(Kostenrechner.getInstance(), panel.isWiderKlageAnzeigen()));
		VerfahrensDatenContainer container = getDialog().showDialogAndAsk();
		setDialog(null);
		if (container != null) {
			panel.setzeWerte(container.streitgenossen);
			panel.requestFocusInWindow();
		}
	}

	/**
	 * @return gibt {@link #dialog} als {@link TenorDialog} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	public BaumbachAssistentDialog getDialog() {
		return dialog;
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link TenorDialog}.
	 * @return
	 */
	public BaumbachAssistentDialog setDialog(BaumbachAssistentDialog dialog) {
		this.dialog = dialog;
		return dialog;
	}
}