/**
 * StreitgenossenBaumbachAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import javax.swing.Action;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.TenorAction;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.logic.baumbach.BaumbachFormel;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die Action prüft die Werte auf dem {@link StreitgenossenPanel} und lässt dann
 * einen Kostentenor nach der Baumbach'schen Kostenformel erzeugen.
 * 
 * @TODO TODO Werden Werte geprüft?
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenBaumbachAction extends TenorAction {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = 8105321861085009090L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel    {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenBaumbachAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	/**
	 * Die Methode prüft, ob alle nötigen Oberflächenelemente non-null sind
	 * 
	 * Wenn Dwbk vorhanden, dann die Werte aller drei Tabellen zusammenfügen,
	 * ansonsten nur die von Klägern und Beklagten.
	 * 
	 * @return <code>true</code>, wenn {@link #alleWerte()} gefahrlos laufen kann.
	 * @throws IllegalArgumentException wird ansonsten geworfen (<code>false</code>
	 *                                  gibt es nicht), damit die {@link Exception}
	 *                                  direkt behandelt werden kann.
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#allesOk()
	 */
	@Override
	protected boolean allesOk() throws IllegalArgumentException {
		if (!panel.pruefeTabellen()) {
			throw new IllegalArgumentException(StreitgenossenPanel.FEHLER_NIX_PARTEIEN_LANG);
		}
		return true;
	}

	/**
	 * Die Methode ruft {@link BaumbachFormel} auf.
	 * 
	 * @param container einen {@link VerfahrensDatenContainer}, den
	 *                  {@link TenorAction} über
	 *                  {@link XmlTransferHandler#liesAlleWertefuerContainer()}
	 *                  zusammenstellt
	 * @return den {@link TenorDatenContainer}
	 * @throws IllegalArgumentException wenn was schief läuft
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#tenorDaten(eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer)
	 */
	@Override
	protected TenorDatenContainer tenorDaten(VerfahrensDatenContainer container) throws IllegalArgumentException {
		return new BaumbachFormel(container).erzeugeContainer();
	}

}