/*
 * StreitgenossenExtractAndCancelAction.java
 * eu.gronos.kostenrechner.controller.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Ermöglicht eine Action aufzurufen und dann noch eine, hier für
 * {@link StreitgenossenGesamtschuldBkExtractAction} und
 * {@link HinzufuegenDialog#getCancelAction()}
 *
 * @author Peter Schuster (setrok)
 * @date 20.07.2019
 *
 */
public class StreitgenossenExtractAndCancelAction extends BeschriebeneAktion {
	private static final long serialVersionUID = -6205218097482631610L;
	private final AbstractAction eins;
	private final AbstractAction zwei;

	public StreitgenossenExtractAndCancelAction(LangBeschriftung beschriftung, AbstractAction eins,
			AbstractAction zwei) {
		super(beschriftung);
		this.eins = eins;
		this.zwei = zwei;
	}

	/**
	 * Die Methode verknüpft die beiden {@link AbstractAction}s.
	 * 
	 * @param e ein {@link ActionEvent}
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		eins.actionPerformed(e);
		zwei.actionPerformed(e);
	}

}
