/**
 * StreitgenossenGesamtschuldDwbkExtractAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die {@link Action} geht die Beteiligten einer Seite durch und guckt, ob sie
 * z.T. gesamtschuldnerisch verurteilt wurden. {@link KeyEvent#VK_W}
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenGesamtschuldDwbkExtractAction extends BeschriebeneAktion {
	private final StreitgenossenTabellenBehandelnd handler;
	private static final long serialVersionUID = 8105321861085009090L;

	/**
	 * Konstruktor.
	 * 
	 * @param handler  {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenGesamtschuldDwbkExtractAction(StreitgenossenTabellenBehandelnd handler,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO ALLES PRÜFEN!
		// WICHTIG: Vorher echte Kopie anlegen!
		BaumbachBeteiligtenListe beteiligte = new BaumbachBeteiligtenListe();
		BeteiligtenTableModel btmKlaeger = handler.getTableModel(BeteiligtenTyp.KLAEGER.ordinal());
		BeteiligtenTableModel btmDrittwiderbeklagte = handler
				.getTableModel(BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal());
		beteiligte.addAll(btmKlaeger.getAllValues());
		beteiligte.addAll(btmDrittwiderbeklagte.getAllValues());
		if (beteiligte == null || beteiligte.size() < 2)
			return;
		BaumbachGesamtschuldnerschaft gesamtschuldnerschaft = beteiligte
				.extrahiereGesamtschuldnerschaft(btmDrittwiderbeklagte.getBeteiligtenTyp());
		if (gesamtschuldnerschaft != null) {
			btmDrittwiderbeklagte.addRow(gesamtschuldnerschaft);
			Kostenrechner.getLogger().info("Schleife");
			// Rekursion, sofern Rückgabe nicht null: Bei Dwbk nicht gut...
			actionPerformed(e);
			// Und das Model muss was von der Änderung mitbekommen.
			btmKlaeger.fireTableDataChanged();
			btmDrittwiderbeklagte.fireTableDataChanged();
		} else {
			Kostenrechner.getLogger().info("Schleife endet!");
		}
	}
}