/**
 * StreitgenossenGesamtschuldnerBkAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.view.baumbach.GesamtschuldnerDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die Action fügt eine gesamtschuldnerische Verurteilung zur Tabelle der
 * Beklagten hinzu.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenGesamtschuldnerBkAction extends BeschriebeneAktion
		implements AbfrageLieferant<GesamtschuldnerDialog> {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = 3348162188610732190L;
	private GesamtschuldnerDialog dialog = null;

	/**
	 * Konstruktor.
	 * 
	 * @param panel    {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenGesamtschuldnerBkAction(StreitgenossenTabellenBehandelnd panel,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		try {
			setDialog(new GesamtschuldnerDialog(panel.getKostenrechner(),
					panel.getTableModel(BeteiligtenTyp.BEKLAGTE.ordinal()).getAllValues(),
					panel.getExtrahierenAktion(BeteiligtenTyp.BEKLAGTE)));
			BaumbachGesamtschuldnerschaft bt = getDialog().showDialogAndAsk();
			if (bt != null)
				panel.getTableModel(BeteiligtenTyp.BEKLAGTE.ordinal()).addRow(bt);
		} catch (IllegalArgumentException iae) {
			// Meldung, wenn noch keine Beteiligten in Tabelle
			FehlerHelper.zeigeFehler(iae.getLocalizedMessage(), iae);
		} finally {
			setDialog(null);
		}
	}

	/**
	 * @return gibt {@link #dialog} als {@link GesamtschuldnerDialog} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	public GesamtschuldnerDialog getDialog() {
		return dialog;
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link GesamtschuldnerDialog}.
	 */
	private void setDialog(GesamtschuldnerDialog dialog) {
		this.dialog = dialog;
	}
}