/**
 * LadeSkktx.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.BerechnungFileChooser;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.result.TenorDialog;

/**
 * Die {@link Action} ruft einen {@link BerechnungFileChooser} auf. Der lädt die
 * Daten aller Registerkarten aus einer früher gespeicherten Berechnung (Strg+O)
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class LadeSkktxAction extends BeschriebeneAktion implements AbfrageLieferant<JDialog> {
	private static final long serialVersionUID = -2225698692818848010L;
	private JFrame frame;
	private BerechnungFileChooser fileChooser;

	/**
	 * Konstruktor.
	 * 
	 * @param frame          ein {@link JFrame}, z.B. {@link Kostenrechner}
	 * @param mnemonic       {@link Action#MNEMONIC_KEY}
	 * @param acceleratorKey {@link Action#ACCELERATOR_KEY}
	 */
	public LadeSkktxAction(JFrame frame, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.frame = frame;
	}
	
	@Override
	public void actionPerformed(ActionEvent ae) {
		fileChooser = new BerechnungFileChooser((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
		final VerfahrensDatenContainer container = fileChooser.ladeXmlDialog(this.frame);// menu.getKostenrechner()
		fileChooser = null;
		if (container != null) {
			new XmlTransferHandler().setzeAlleWerteAusContainer(container);
			// Wenn ein TenorDatenContainer (.rtf.skktx) geladen wird, erwartet der Nutzer
			// wohl, dass sich auch der TenorDialog öffnet.
			if (container instanceof TenorDatenContainer) {
				new TenorDialog(this.frame, (TenorDatenContainer) container).showDialog();
			}
		}
	}

	/**
	 * Die Methode leitet die Abfrage auf den {@link BerechnungFileChooser} um.
	 * 
	 * @return den {@link KostenFileChooser#getDialog()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public JDialog getDialog() {
		if (fileChooser != null) {
			return fileChooser.getDialog();
		}
		return null;
	}
}