/*
 * MouseLogHorcher.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.IOException;

import javax.swing.JLabel;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;

/**
 * Die Klasse macht das ausgehorchte Objekt zu einem Hyperlink zu
 * {@link Kostenrechner#getLogFile()} mit MouseOver-Effekt.
 *
 * @author Peter Schuster (setrok)
 * @date 25.01.2020
 *
 */
public final class MausLogHorcher extends AllzweckHorcher {
	/**
	 * colorBAK speichert die Farbe des {@link MouseEvent#getSource()} als
	 * {@link Color}, damit sie wiederhergestellt werden kann.
	 */
	private Color colorBAK;

	@Override
	public void mouseClicked(MouseEvent e) {
		try {
			Desktop.getDesktop().open(Kostenrechner.getLogFile().toFile());
		} catch (IOException error) {
			FehlerHelper.zeigeFehler("Fehler beim Auffinden der Log-Datei", error);
		}
	}

	/**
	 * Die Methode färbt Links ein, wenn die Maus darüber fährt. Die bisherige Farbe
	 * wird gesichert.
	 * 
	 * @param me ein {@link MouseEvent}
	 * 
	 * @see eu.gronos.kostenrechner.controller.AllzweckHorcher#mouseEntered(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseEntered(MouseEvent me) {
		Object source = me.getSource();
		if (source instanceof JLabel) {
			JLabel label = (JLabel) source;
			colorBAK = label.getForeground();
			label.setForeground(Color.BLUE);
		}
	}

	/**
	 * Die Methode setzt die Farbe des {@link JLabel}s wieder zurück.
	 * 
	 * @param me ein {@link MouseEvent}
	 * 
	 * @see eu.gronos.kostenrechner.controller.AllzweckHorcher#mouseExited(java.awt.event.MouseEvent)
	 */
	@Override
	public void mouseExited(MouseEvent me) {
		Object source = me.getSource();
		if (source instanceof JLabel && colorBAK != null) {
			JLabel label = (JLabel) source;
			label.setForeground(colorBAK);
		}
	}

}