/**
 * SpeichereSkktx.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.JDialog;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.BerechnungFileChooser;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.menus.DateiJMenu;

/**
 * {@link Action}, die über {@link BerechnungFileChooser} die Daten aller
 * Registerkarten für spätere Berechnungen abspeichert
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class SpeichereSkktxAction extends BeschriebeneAktion implements AbfrageLieferant<JDialog> {
	private final DateiJMenu menu;
	private static final long serialVersionUID = 8642800626569995070L;
	private BerechnungFileChooser fileChooser = null;

	/**
	 * Konstruktor.
	 * 
	 * @param menu           Verweis auf {@link DateiJMenu}
	 * @param mnemonic       {@link Action#MNEMONIC_KEY}
	 * @param acceleratorKey {@link Action#ACCELERATOR_KEY}
	 */
	public SpeichereSkktxAction(DateiJMenu menu, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.menu = menu;
	}
	// String name, String shortDescription, String actionCommandKey, , int
	// mnemonic,
	// KeyStroke acceleratorKey
	// name, shortDescription, actionCommandKey, , mnemonic, acceleratorKey

	@Override
	public void actionPerformed(ActionEvent ae) {
		final VerfahrensDatenContainer container = new XmlTransferHandler().liesAlleWertefuerContainer();
		fileChooser = new BerechnungFileChooser((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
		fileChooser.showSaveDialog(this.menu.getKostenrechner(), container);
		fileChooser = null;
	}
	// new VerfahrensDatenContainer2GUI().

	/**
	 * Die Methode leitet die Abfrage auf den {@link BerechnungFileChooser} um.
	 * 
	 * @return den {@link KostenFileChooser#getDialog()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public JDialog getDialog() {
		if (fileChooser != null) {
			return fileChooser.getDialog();
		}
		return null;
	}
}