/**
 * GebuehrenNormalAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;

/**
 * Die {@link Action} leert die Tabelle mit den Gebührentatbeständen des
 * Rechners und füllt sie mit der Konstellation und füllt sie mit der
 * Konstellation eines normalen erstinstanzlichen Verfahrens,
 * {@link KeyEvent#VK_UNDEFINED}, oder füllt sie mit der Konstellation Gebühren
 * bei Anerkenntnis, {@link KeyEvent#VK_G}, oder füllt sie mit der Konstellation
 * Gebühren bei Säumnis, {@link KeyEvent#VK_S}, oder füllt sie mit der
 * Konstellation und füllt sie mit der Konstellation eines normalen
 * erstinstanzlichen Verfahrens mit anschließender Berufung
 * {@link KeyEvent#VK_UNDEFINED}
 * 
 * @author Peter Schuster (setrok)
 * @date 04.11.2018
 */
public class GebuehrenSetzeRechnerTabelleAction extends BeschriebeneAktion {
	private final GebuehrenTableTextfieldHandler handler;
	private static final long serialVersionUID = 5567272748853539208L;
	private int key;
	public static final int GEBUEHREN_2INSTANZ = 104;
	public static final int GEBUEHREN_STANDARD = 103;
	public static final int GEBUEHREN_SAEUMNIS = 102;
	public static final int GEBUEHREN_ANERKENNTNIS = 101;

	/**
	 * Konstruktor.
	 * 
	 * @param handler      Verweis auf {@link GebuehrenBerechnungPanel}
	 * @param beschriftung eine {@link LangBeschriftung}, die auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),{@link Action#MNEMONIC_KEY},
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 * @param key          ein int,
	 *                     {@link GebuehrenSetzeRechnerTabelleAction#GEBUEHREN_ANERKENNTNIS},
	 *                     {@link GebuehrenSetzeRechnerTabelleAction#GEBUEHREN_SAEUMNIS},
	 *                     {@link GebuehrenSetzeRechnerTabelleAction#GEBUEHREN_STANDARD}
	 *                     oder
	 *                     {@link GebuehrenSetzeRechnerTabelleAction#GEBUEHREN_2INSTANZ}
	 */
	public GebuehrenSetzeRechnerTabelleAction(GebuehrenTableTextfieldHandler handler, LangBeschriftung beschriftung,
			int key) {
		super(beschriftung);
		this.handler = handler;
		this.key = key;
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		setzeGebuehrenRechnerTabelle(key);
		handler.requestFocusInWindow();
		//processe(event);
	}

	/**
	 * Die Methode leert die GebuehrenRechnerTabelle oder füllt sie mit
	 * üblicherweise anfallenden Gebühren, lässt aber die Listener in Ruhe.
	 * 
	 * @param key 0 = Tabelle leeren, {@link #GEBUEHREN_ANERKENNTNIS} = Tabelle mit
	 *            den bei einem Anerkenntnis üblicherweise anfallenden Gebühren
	 *            füllen, {@link #GEBUEHREN_SAEUMNIS} Tabelle mit den bei einer
	 *            Säumnis üblicherweise anfallenden Gebühren füllen
	 * 
	 */
	private void setzeGebuehrenRechnerTabelle(int key) {
		List<GebuehrenTatbestand> values;
		switch (key) {
		case GEBUEHREN_STANDARD:
			values = new ArrayList<GebuehrenTatbestand>();
			values.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV"));
			values.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3104 VV", "7002 VV",
					"7008 (R) VV", "3100 VV", "3104 VV", "7002 VV", "7008 (R) VV"));
			break;
		case GEBUEHREN_ANERKENNTNIS:
			values = new ArrayList<GebuehrenTatbestand>();
			values.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1211 KV"));
			values.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3104 VV", "7002 VV",
					"7008 (R) VV", "3100 VV", "3104 VV", "7002 VV", "7008 (R) VV"));
			break;
		case GEBUEHREN_SAEUMNIS:
			values = new ArrayList<GebuehrenTatbestand>();
			values.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV"));
			values.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3105 VV", "7002 VV",
					"7008 (R) VV", "3100 VV", "7002 VV", "7008 (R) VV"));
			break;
		case GEBUEHREN_2INSTANZ:
			values = new ArrayList<GebuehrenTatbestand>();
			values.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV", "1220 KV"));
			values.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3104 VV", "7002 VV",
					"3200 VV", "3202 VV", "7002 VV", "7008 (R) VV", "3100 VV", "3104 VV", "7002 VV", "3200 VV",
					"3202 VV", "7002 VV", "7008 (R) VV"));
			break;
		default:
			values = new ArrayList<GebuehrenTatbestand>();
			break;
		}
		GebuehrenTableModel gttm = handler.getTableModel(GebuehrenBerechnungPanel.TABLE_GEBUEHREN);
		gttm.clear();
		gttm.addAll(values);
	}

}