/**
 * GebuehrenStreitwertHorcher.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.model.gebuehren.StreitwertTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;

/**
 * Die Klasse stellt sicher, dass im {@link GebuehrenBerechnungPanel} das
 * Streitwert-JFormattedTextfield und die dazugehörige JTable immer denselben
 * Streitwert haben.
 * 
 * @author Peter Schuster (setrok)
 * @date 25.10.2018
 *
 */
public class GebuehrenStreitwertHorcher extends AllzweckHorcher {
	private GebuehrenBerechnungPanel panel;
	private String beschriftung;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link GebuehrenBerechnungPanel}
	 * @param beschriftung ein {@link String} der Beschriftung des {@link JLabel}s
	 *                     für den {@link NumberExtractor}
	 */
	public GebuehrenStreitwertHorcher(GebuehrenBerechnungPanel panel, String beschriftung) {
		this.panel = panel;
		this.beschriftung = beschriftung;
	}

	@Override
	public void keyReleased(KeyEvent ke) {
		Object source = ke.getSource();
		if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
			if (source instanceof JTable) {
				SwingUtilities.invokeLater(() -> ftfAnTableAnpassen((JTable) source));
			} else if (source instanceof JFormattedTextField) {
				SwingUtilities.invokeLater(() -> tableAnFtfAnpassen((JFormattedTextField) source, beschriftung));
			}
		}
	}

	@Override
	public void keyTyped(KeyEvent ke) {
		keyReleased(ke);
	}

	@Override
	public void mouseClicked(MouseEvent me) {
		Object source = me.getSource();
		if (source instanceof JTable && me.getClickCount() > 1)
			ftfAnTableAnpassen((JTable) source);
	}

	@Override
	public void focusLost(FocusEvent fe) {
		Object source = fe.getSource();
		if (source instanceof JTable) {
			SwingUtilities.invokeLater(() -> ftfAnTableAnpassen((JTable) source));
		} else if (source instanceof JFormattedTextField) {
			SwingUtilities.invokeLater(() -> tableAnFtfAnpassen((JFormattedTextField) source, beschriftung));
		}
	}

	@Override
	public void valueChanged(ListSelectionEvent lse) {
		Object source = lse.getSource();
		if (source instanceof ListSelectionModel)
			ftfAnTableAnpassen(this.panel.getTabStreitwertTabelle());
	}

	@Override
	public void tableChanged(TableModelEvent tme) {
		this.panel.errechneGebuehrenSumme();
	}

	private void tableAnFtfAnpassen(JFormattedTextField ftf, String beschriftung) {
		if (!(this.panel.getTabStreitwertTabelle().getModel() instanceof StreitwertTableModel))
			this.panel.initStreitwertTable();
		// long streitwert = 0L;
//		double streitwert = 0.0;
		Euro streitwert = Euro.ofCents(0L);
		if (ftf.isEditValid())
			try {
				streitwert = Euro.ofEuros(new NumberExtractor(ftf, beschriftung).extractLong());
				int zeile = ((StreitwertTableModel) this.panel.getTabStreitwertTabelle().getModel())
						.rowAtStreitwert(streitwert);
				if (zeile > -1)
					this.panel.getTabStreitwertTabelle().changeSelection(zeile, -1, false, false);
				this.panel.errechneGebuehrenSumme();
			} catch (NumberFormatException e) {
				FehlerHelper.zeigeFehler("Falsches Eingabeformat!", e);
			}
	}

	private void ftfAnTableAnpassen(JTable table) {
		if (!(table.getModel() instanceof StreitwertTableModel))
			this.panel.initStreitwertTable();
		final int selectedRow = table.getSelectedRow();
		if (selectedRow < 0)
			return;
//		final Long valueAt = (Long) table.getModel().getValueAt(selectedRow, 0);
		final Euro valueAt = (Euro) table.getModel().getValueAt(selectedRow, 0);
		System.out.println("valueAt:" + valueAt);
//		final Double valueAt = (Double) table.getModel().getValueAt(selectedRow, 0);
		panel.getFormattedTextField(GebuehrenBerechnungPanel.FTF_STREITWERT)
				.setText(Long.toString(valueAt.longValue()));// valueAt.toString()
		panel.errechneGebuehrenSumme();
	}
}