/**
 * GebuehrenTabelleDruckenAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.text.MessageFormat;

import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.JTable.PrintMode;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;

/**
 * Die {@link Action} druckt den Inhalt der Streitwerttabelle über
 * {@link JTable#print()}
 *
 * @author Peter Schuster (setrok)
 * @date 04.11.2018
 *
 */
public class GebuehrenTabelleDruckenAction extends BeschriebeneAktion {
	private final GebuehrenBerechnungPanel panel;
	private static final long serialVersionUID = 8046359053768482197L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link GebuehrenBerechnungPanel}
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),{@link Action#MNEMONIC_KEY},
	 *                     {@link Action#ACCELERATOR_KEY}
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 */
	public GebuehrenTabelleDruckenAction(GebuehrenBerechnungPanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		try {
			boolean fertig = panel.getTabStreitwertTabelle().print(PrintMode.FIT_WIDTH,
					new MessageFormat("Streitwerttabelle"),
					new MessageFormat(((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(100)).getTitle()
							+ Kostenrechner.KOSTENRECHNER_VERSION + "\t Seite {0}"));
			if (fertig)
				;
		} catch (PrinterException pe) {
			FehlerHelper.zeigeFehler(GebuehrenBerechnungPanel.FEHLER_DRUCKEN, pe);
		}
	}
}