/**
 * TeiklageRuecknahmeTerminAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die {@link Action} leert die Tabelle mit den Gebührentatbeständen und füllt
 * sie mit der Konstellation Teilklagerücknahme vor Anfall der Terminsgebühr.
 * {@link KeyEvent#VK_F}
 */
public class TeilklageTerminAction extends BeschriebeneAktion {
	private final GebuehrenTableTextfieldHandler handler;
	private static final long serialVersionUID = -7826777167427931422L;

	/**
	 * Konstruktor.
	 * 
	 * @param handler      Verweis auf {@link TeilklageruecknahmePanel}
	 * @param beschriftung eine Lang{@link LangBeschriftung}, auch mit
	 *                     {@link Action#MNEMONIC_KEY}
	 */
	public TeilklageTerminAction(GebuehrenTableTextfieldHandler handler, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
	}

	/**
	 * Die Methode füllt die Tabellen mit den Tatbeständen zum Standardfall, wenn
	 * mit den Tatbeständen zum Standardfall gefüllt werden sollen.
	 */
	@Override
	public void actionPerformed(ActionEvent event) {
		GebuehrenTableModel gttm = handler.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_VORHER);

		gttm.clear();
		gttm.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV"));
		gttm.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3100 VV"));

		gttm = handler.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_NACHHER);
		gttm.clear();
		gttm.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3104 VV", "3104 VV"));

		handler.requestFocusInWindow();
	}

}