/**
 * TeilklageRuecknahmeVerschiebenAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die {@link Action} entfernt den markierten Eintrag aus dieser Tabelle und
 * fügt ihn der jeweils anderen hinzu. Soll ins Kontextmenü.
 * {@link KeyEvent#VK_T}
 *
 */
public class TeilklageVerschiebenAction extends BeschriebeneAktion {
	protected final GebuehrenTableTextfieldHandler panel;
	private static final long serialVersionUID = 2748367225462023438L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link TeilklageruecknahmePanel}
	 * @param beschriftung die {@link LangBeschriftung}, auch mit
	 *                     {@link Action#MNEMONIC_KEY}
	 */
	public TeilklageVerschiebenAction(GebuehrenTableTextfieldHandler panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}


	@Override
	public void actionPerformed(ActionEvent event) {
		Object o = event.getSource();
		String source = null;
		// Herausfinden, welche Tabelle ruft
		if (o instanceof JMenuItem) {
			final JPopupMenu popup = (JPopupMenu) ((JMenuItem) o).getParent();
			source = popup.getName();
		} else if (o instanceof JTable) {
			final JTable table = (JTable)o;
			source = table.getName();
		} else {
			System.err.printf("Kein JMenuItem: %s!%n", o.getClass().toString());
			return;
		}
		if (panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_VORHER) == null
				|| panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_NACHHER) == null) {
			return;
		}
		if (source.equals("17100") || source.equals("12011")) {//Menu oder Tabelle
			verschiebeGebuehrenTatbestand(panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_VORHER),
					panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_NACHHER),
					panel.getSelectedRow(TeilklageruecknahmePanel.TABLE_FTF_VORHER));
		} else if (source.equals("17200") || source.equals("13011")) {//Menu oder Tabelle
			verschiebeGebuehrenTatbestand(panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_NACHHER),
					panel.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_VORHER),
					panel.getSelectedRow(TeilklageruecknahmePanel.TABLE_FTF_NACHHER));
		}
	}

	/**
	 * Die Methode verschiebt einen Gebührentatbestand aus einer JTable in die
	 * andere.
	 * 
	 * 
	 * @param ausgang     das {@link GebuehrenTableModel}, aus der die Zeile
	 *                    gelöscht werden soll
	 * @param ziel        das {@link GebuehrenTableModel}, in die die Zeile
	 *                    verschoben werden soll
	 * @param selectedRow {@link JTable#getSelectedRow()} der Ausgangstabelle
	 */
	protected void verschiebeGebuehrenTatbestand(GebuehrenTableModel ausgang, GebuehrenTableModel ziel,
			int selectedRow) {
		if (ausgang == null || ziel == null || selectedRow < 0)
			return;
		ziel.addRow(ausgang.getRow(selectedRow));
		ausgang.removeRow(selectedRow);
	}

}