/**
 * GplAnzeigenToggleAction.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangVorsorgeBeschriftung;
import eu.gronos.kostenrechner.view.helpanderror.LizenzZustimmungDialog;

/**
 * Je nach Betätigung dieser Action zeigt das Fenster die gesamte Lizenz (GPL
 * 3.0) oder die für das Programm spezifische Kurzfassung der Lizenz an."
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class GplAnzeigenToggleAction extends BeschriebeneAktion {
	private final LizenzZustimmungDialog dialog;
	private static final long serialVersionUID = -5478738058066499706L;
	private boolean ausfuehrlich = false;
	private LangVorsorgeBeschriftung beschriftung;

	/**
	 * 
	 * @param dialog   die Instanz des {@link LizenzZustimmungDialog}-Dialogs
	 * @param mnemonic ({@link javax.swing.Action#MNEMONIC_KEY}) The key used for
	 *                 storing an Integer that corresponds to one of the KeyEvent
	 *                 key codes. The value is commonly used to specify a mnemonic.
	 *                 KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the
	 *                 mnemonic of myAction to Cyrillic letter "Ef".
	 */
	public GplAnzeigenToggleAction(LangVorsorgeBeschriftung beschriftung, LizenzZustimmungDialog dialog) {
		super(beschriftung);
		this.dialog = dialog;
		this.beschriftung = beschriftung;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		if (!ausfuehrlich) {
			dialog.setHtml("resources/gpl3.html");
			putValue(Action.MNEMONIC_KEY, KeyEvent.VK_L);
			beschrifter.changeTo(beschriftung, 1);
			ausfuehrlich = true;
		} else {
			dialog.setHtml("resources/lizenz.html");
			putValue(Action.MNEMONIC_KEY, KeyEvent.VK_G);
			beschrifter.changeTo(beschriftung, 0);
			ausfuehrlich = false;
		}
		beschrifter.beschrifte(this, beschriftung);
	}
}