/**
 * MacOpenFileHandler.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.io.File;
import java.util.List;

import com.apple.eawt.AppEvent.OpenFilesEvent;

import eu.gronos.kostenrechner.util.system.ArgumentParser;

import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;

/**
 * Eine Klasse um Apples Events zum Öffnen von Dateien abzufangen
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class MacOpenFileHandler implements OpenFilesHandler {

	static final MacOpenFileHandler MAC_FILES_HANDLER = new MacOpenFileHandler();

	/**
	 * Die Methode wird aufgerufen, wenn das macOS das Programm benachrichtigt, es
	 * solle Dateien öffnen.
	 * 
	 * @param ofe ein {@link OpenFilesEvent}
	 * 
	 * @see com.apple.eawt.OpenFilesHandler#openFiles(com.apple.eawt.AppEvent.OpenFilesEvent)
	 * @url https://coderanch.com/how-to/javadoc/appledoc/api/com/apple/eawt/OpenFilesHandler.html#openFiles(com.apple.eawt.AppEvent.OpenFilesEvent)
	 * @url https://coderanch.com/how-to/javadoc/appledoc/api/com/apple/eawt/AppEvent.OpenFilesEvent.html
	 */
	@Override
	public void openFiles(OpenFilesEvent ofe) {
		List<File> files = ofe.getFiles();
		if (files == null || files.isEmpty()) {
			return;
		}
		String[] args = new String[] { files.get(0).getAbsolutePath() };
		new ArgumentParser(args).parseDateiname();
	}

	public static void fileHandlerSetzen() {
		try {
			Application.getApplication().setOpenFileHandler(MAC_FILES_HANDLER);
		} catch (NoClassDefFoundError e) {
			System.err.println("Nix can open Apple");
		}
	}
}
