/**
 * EmailTenorFalschAction.java
 * eu.gronos.kostenrechner.view.result (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.util.files.TenorXmlDatei;

/**
 * Die {@link Action} lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client
 * über {@link TenorUtils.emailSchreiben(String, String)} schreiben. Dabei wird
 * der Text des Tenors und noch XML-Daten mitgeschickt.
 * 
 *
 *
 * @author Peter Schuster (setrok)
 * @date 22 Nov 2018
 *
 */
public class SchreibeEmailTenorFalsch extends SchreibeEmail {
	private static final long serialVersionUID = -978875818285786710L;
	private final TenorDatenContainer container;

	/**
	 * Konstruktor.
	 * 
	 * @param container ein {@link TenorDatenContainer}
	 */
	public SchreibeEmailTenorFalsch(LangBeschriftung beschriftung, TenorDatenContainer container) {
		super(beschriftung);
		this.container = container;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final String subject = "Falscher Tenor in kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		// Im E-Mail-Text werden Tenor und noch XML-Daten mitgeschickt
		final String xmlString = super.verkleinere(new TenorXmlDatei().toXmlString(container));
		// Wenn dem Anhang nicht zugestimmt wird, einfache E-Mail schreiben. Bei
		// Zustimmung auch TenorDaten-XML mitschicken
		schreibeDifferenziert(subject,
				"Aus den folgenden Gründen halte ich den Tenor für falsch: " + SchreibeEmail.NEUER_ABSATZ, xmlString);

	}
}