/*
 * Ersetzung.java
 * eu.gronos.kostenrechner.data (Kostenrechner)
 */
package eu.gronos.kostenrechner.data;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * Klasse um Daten fürs E-Mail-Schreiben kleiner zu bekommen durch Ersetzung
 *
 * @author Peter Schuster (setrok)
 * @date 13.12.2020
 *
 */
@XmlType(propOrder = { "replace", "with" })
public class Ersetzung  {

	private String replace;
	private String with;

	/**
	 * @return gibt den Suchbegriff {@link #replace} als {@link String} zurück, also
	 *         den (längeren) Begriff, der ersetzt werden soll.
	 */
	@XmlAttribute(name = "replace")
	public String getReplace() {
		return replace;
	}

	/**
	 * @param replace d. {@link #replace}, d. gesetzt werden soll als
	 *                {@link String}.
	 */
	public void setReplace(String replace) {
		this.replace = replace;
	}

	/**
	 * @return gibt {@link #with} als {@link String} zurück, also den (kürzeren)
	 *         Begriff, der stattdessen gesetzt werden soll.
	 */
	@XmlAttribute(name = "with")
	public String getWith() {
		return with;
	}

	/**
	 * @param with d. {@link #with}, d. gesetzt werden soll als {@link String}.
	 */
	public void setWith(String with) {
		this.with = with;
	}
}