package eu.gronos.kostenrechner.data.baumbach;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.interfaces.UnterContainerKlasse;

/**
 * Neue {@link UnterContainerKlasse} von {@link VerfahrensDatenContainer} für
 * die Registerkarte Streitgenossen mit {@link Angriff}
 *
 * @author Peter Schuster (setrok)
 * @date 23.11.2021
 *
 */
public class StreitgenossenAngriffe implements UnterContainerKlasse {

	/**
	 * speichert die Kläger, die Beklagten und ggfs. die Drittwiderbeklagten, auf
	 * die die {@link #angriffe} verweisen, als {@link List} von
	 * {@link Beteiligter}.
	 */
	@XmlElement(name = "partei")
	public List<Beteiligter> beteiligte = new ArrayList<>();

	/**
	 * speichert die Beteiligten, die für Verweise gebraucht werden, aber keine
	 * wirklichen Parteien sind
	 */
	@XmlElements({ @XmlElement(name = "pseudoPartei", type = Beteiligter.class),
			@XmlElement(name = "staatskasse", type = GerichtsKostenBeteiligter.class),
			@XmlElement(name = "mehrere", type = MehrfachBeteiligter.class) })
	public List<Beteiligter> pseudo = new ArrayList<>();

	/**
	 * speichert die Angriffe zwischen den {@link #beteiligte}n als {@link List} von
	 * {@link Angriff}.
	 */
	@XmlElement(name = "angriff")
	public List<Angriff> angriffe = new AngriffListe();

//	@XmlElements({ 
//	@XmlElement(name = "schuldner", type = Beteiligter.class), @XmlElement(name = "staatskasse", type = GerichtsKostenBeteiligter.class),
//			,@XmlElement(name = "schuldnerMitZusatz", type = BaumbachBeteiligter.class),
//			@XmlElement(name = "gesamtschuldner", type = BaumbachGesamtschuldnerschaft.class) 

	/**
	 * speichert als {@code boolean}, ob Klage und Widerklage wirtschaftlich
	 * identisch im Sinne von &sect;&nbsp;45 Abs. 1 S. 3 GKG sind.
	 */
	@XmlAttribute(name = "p45i3GKG")
	public boolean p45i3GKG = false;

	@Override
	public boolean isEmpty() {
		return (angriffe == null || angriffe.isEmpty()) && (beteiligte == null || beteiligte.isEmpty());
	}

}
