/*
 * Angriffserfolg.java
 * eu.gronos.kostenrechner.model.forderungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.data.forderungen;

import eu.gronos.kostenrechner.data.tenordaten.Euro;

/**
 * Ein Parameterobjekt für das Obsiegen des Klägers in der Hauptsache und auch
 * die vollständige Klageforderung. Ersetzt ein Array double[], bei dem index 0
 * die komplette Klage war (jetzt {@link #getVolleForderung()}) und index 1 die verbleibende Klageforderung für den
 * Tenor (jetzt {@link #getErfolg()}).
 *
 * @author Peter Schuster (setrok)
 * @date 5 Jun 2019
 *
 */
public class Angriffserfolg {

	private final Euro volleForderung;//double
	private final Euro erfolg;//double verbleibend

	/**
	 * Konstruktor.
	 * 
	 * @param volleForderung die komplette Klage, war hauptsache[0]
	 * @param erfolg         die verbleibende Klageforderung für den Tenor, war
	 *                       hauptsache[1]
	 */
	public Angriffserfolg(Euro volleForderung, Euro erfolg) {
		this.volleForderung = volleForderung;
		this.erfolg = erfolg;
	}

	/**
	 * @return gibt {@link #volleForderung} als {@link double} zurück, die komplette
	 *         Klage, war hauptsache[0].
	 */
	public Euro getVolleForderung() {
		return volleForderung;
	}

	/**
	 * @return gibt {@link #erfolg} als {@link double} zurück, die verbleibende
	 *         Klageforderung für den Tenor, war hauptsache[1]
	 */
	public Euro getErfolg() {
		return erfolg;
	}

}
